/**
 * @file ProtocolManagerData.cpp
 *
 * @par SW-Component
 * State machine for protocol manager
 *
 * @brief Implementation of protocol manager data.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of protocol manager data.
 */

#include "ProtocolManagerData.h"

namespace btstackif {

ProtocolManagerData::ProtocolManagerData() :
connectionOriginator(BTS_PAIR_CONNECT_INITIATED_LAST),
connected(false),
stackReason(BTS_DISCONNECT_REASON_NOT_VALID),
reason(BTS_DISCONNECT_REASON_NOT_VALID),
rfCommDevice(),
remotePending(false),
localPending(false),
acceptPending(false),
info(),
secondaryInfo(0),
operationId(0),
sppInstance(0),
sm(),
configureSm(),
setPageTimeoutActive(false),
requestItem(),
timer(),
retryMax(0),
retryNmb(0),
sdpRecordPending(false),
masName(),
linkageMaster(false),
linkageUuid(),
charDevTimer(),
connectTimer(),
disconnectTimer()
{
}

ProtocolManagerData::~ProtocolManagerData()
{
}

ProtocolManagerData::ProtocolManagerData(const ProtocolManagerData& ref) :
connectionOriginator(ref.connectionOriginator),
connected(ref.connected),
stackReason(ref.stackReason),
reason(ref.reason),
rfCommDevice(ref.rfCommDevice),
remotePending(ref.remotePending),
localPending(ref.localPending),
acceptPending(ref.acceptPending),
info(ref.info),
secondaryInfo(ref.secondaryInfo),
operationId(ref.operationId),
sppInstance(ref.sppInstance),
sm(ref.sm),
configureSm(ref.configureSm),
setPageTimeoutActive(ref.setPageTimeoutActive),
requestItem(ref.requestItem),
timer(ref.timer),
retryMax(ref.retryMax),
retryNmb(ref.retryNmb),
sdpRecordPending(ref.sdpRecordPending),
masName(ref.masName),
linkageMaster(ref.linkageMaster),
linkageUuid(ref.linkageUuid),
charDevTimer(ref.charDevTimer),
connectTimer(ref.connectTimer),
disconnectTimer(ref.disconnectTimer)
{
}

ProtocolManagerData& ProtocolManagerData::operator=(const ProtocolManagerData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   connectionOriginator = ref.connectionOriginator;
   connected = ref.connected;
   stackReason = ref.stackReason;
   reason = ref.reason;
   rfCommDevice = ref.rfCommDevice;
   remotePending = ref.remotePending;
   localPending = ref.localPending;
   acceptPending = ref.acceptPending;
   info = ref.info;
   secondaryInfo = ref.secondaryInfo;
   operationId = ref.operationId;
   sppInstance = ref.sppInstance;
   sm = ref.sm;
   configureSm = ref.configureSm;
   setPageTimeoutActive = ref.setPageTimeoutActive;
   requestItem = ref.requestItem;
   timer = ref.timer;
   retryMax = ref.retryMax;
   retryNmb = ref.retryNmb;
   sdpRecordPending = ref.sdpRecordPending;
   masName = ref.masName;
   linkageMaster = ref.linkageMaster;
   linkageUuid = ref.linkageUuid;
   charDevTimer = ref.charDevTimer;
   connectTimer = ref.connectTimer;
   disconnectTimer = ref.disconnectTimer;

   return *this;
}

bool ProtocolManagerData::operator==(const ProtocolManagerData& ref) const
{
   bool result = true;

   result = (true == result) && (connectionOriginator == ref.connectionOriginator);
   result = (true == result) && (connected == ref.connected);
   result = (true == result) && (stackReason == ref.stackReason);
   result = (true == result) && (reason == ref.reason);
   result = (true == result) && (rfCommDevice == ref.rfCommDevice);
   result = (true == result) && (remotePending == ref.remotePending);
   result = (true == result) && (localPending == ref.localPending);
   result = (true == result) && (acceptPending == ref.acceptPending);
   result = (true == result) && (info == ref.info);
   result = (true == result) && (secondaryInfo == ref.secondaryInfo);
   result = (true == result) && (operationId == ref.operationId);
   result = (true == result) && (sppInstance == ref.sppInstance);
   result = (true == result) && (sm == ref.sm);
   result = (true == result) && (configureSm == ref.configureSm);
   result = (true == result) && (setPageTimeoutActive == ref.setPageTimeoutActive);
   result = (true == result) && (requestItem == ref.requestItem);
   result = (true == result) && (timer == ref.timer);
   result = (true == result) && (retryMax == ref.retryMax);
   result = (true == result) && (retryNmb == ref.retryNmb);
   result = (true == result) && (sdpRecordPending == ref.sdpRecordPending);
   result = (true == result) && (masName == ref.masName);
   result = (true == result) && (linkageMaster == ref.linkageMaster);
   result = (true == result) && (linkageUuid == ref.linkageUuid);
   result = (true == result) && (charDevTimer == ref.charDevTimer);
   result = (true == result) && (connectTimer == ref.connectTimer);
   result = (true == result) && (disconnectTimer == ref.disconnectTimer);

   return result;
}

bool ProtocolManagerData::operator!=(const ProtocolManagerData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
