/**
 * @file ConfigurePageTimeout.h
 *
 * @par SW-Component
 * State machine for configure page timeout
 *
 * @brief Implementation of configure page timeout state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of configure page timeout state machine.
 */

#ifndef _CONFIGURE_PAGE_TIMEOUT_H_
#define _CONFIGURE_PAGE_TIMEOUT_H_

#include "BtStackInternalTypes.h"
#include "IConfigurePageTimeout.h"
#include "IBasicResultCallback.h"

namespace btstackif {

/**
 * Configure page timeout state machine class.
 */
class ConfigurePageTimeout : public IConfigurePageTimeout, public IBasicResultCallback
{
public:
   /**
    * Default constructor.
    */
   ConfigurePageTimeout();

   /**
    * Destructor.
    */
   virtual ~ConfigurePageTimeout();

   virtual void setBasicConfigurationIf(IN IBasicConfiguration* basicConfigurationIf);

   virtual void setProtocolSmHelper(IN IProtocolSmHelper* helper);

   virtual void resetStateMachine(void);

   virtual bool configure(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSTimeValue pageTimeout, IN const IConfiguration& configurationIf);

   virtual void handleBasicResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSRequestResult result);

private:
   IBasicConfiguration* _basicConfigurationIf; /**< basic configuration interface */
   IProtocolSmHelper* _protocolSmHelper; /**< protocol SM helper interface */
   BTSTimeValue _requestedPageTimeout; /**< requested page timeout */
   BTSTimeValue _calculatedPageTimeout; /**< requested page timeout */
   BTSConfigurationParameter _ongoingConfiguration; /**< current configuration parameter configuration sequence is ongoing for */

   BTSTimeValue calculateTimeout(IN const BTSTimeValue pageTimeout, IN const IConfiguration& configurationIf) const;

   void handleEndOfConfiguration(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSRequestResult result);
};

} //btstackif

#endif //_CONFIGURE_PAGE_TIMEOUT_H_
