/**
 * @file InquiryData.cpp
 *
 * @par SW-Component
 * State machine for inquiry
 *
 * @brief Implementation of inquiry data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of inquiry data.
 */

#include "InquiryData.h"

namespace btstackif {

InquiryData::InquiryData() :
name()
{
}

InquiryData::~InquiryData()
{
}

InquiryData::InquiryData(const InquiryData& ref)
{
   name = ref.name;
}

InquiryData& InquiryData::operator=(const InquiryData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   name = ref.name;

   return *this;
}

bool InquiryData::operator==(const InquiryData& ref) const
{
   bool result = true;

   result = (true == result) && (name == ref.name);

   return result;
}

bool InquiryData::operator!=(const InquiryData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
