/**
 * @file IInquiryObserver.h
 *
 * @par SW-Component
 * State machine for inquiry
 *
 * @brief Interface definition for inquiry observer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the interface for inquiry observer.
 */

#ifndef _I_INQUIRY_OBSERVER_H_
#define _I_INQUIRY_OBSERVER_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class IInquiryObserver
{
public:
   /**
    * Destructor.
    */
   virtual ~IInquiryObserver() {}

   /**
    * Signal for changed discovering status.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] status: discovering status
    */
   virtual void discoveringStatusChanged(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDiscoveringStatus status) = 0;
};

} //btstackif

#endif //_I_INQUIRY_OBSERVER_H_
