/**
 * @file DeviceManagerData.cpp
 *
 * @par SW-Component
 * State machine for device manager
 *
 * @brief Implementation of device manager data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of device manager data.
 */

#include "DeviceManagerData.h"

namespace btstackif {

DeviceManagerData::DeviceManagerData() :
name(),
cod(0),
info(),
reason(BTS_DISCONNECT_REASON_NOT_VALID),
secondaryInfo(0),
requestItem(),
timer(),
master(false),
powerMode(BTS_BT_POWER_MODE_LAST),
disconnectedByException(false),
retryMax(0),
retryNmb(0),
waitForDisconnectedUpdate(false),
enableAvpPause(false),
pauseBtStreaming(false)
{
}

DeviceManagerData::~DeviceManagerData()
{
}

DeviceManagerData::DeviceManagerData(const DeviceManagerData& ref)
{
   name = ref.name;
   cod = ref.cod;
   info = ref.info;
   reason = ref.reason;
   secondaryInfo = ref.secondaryInfo;
   requestItem = ref.requestItem;
   timer = ref.timer;
   master = ref.master;
   powerMode = ref.powerMode;
   disconnectedByException = ref.disconnectedByException;
   retryMax = ref.retryMax;
   retryNmb = ref.retryNmb;
   waitForDisconnectedUpdate = ref.waitForDisconnectedUpdate;
   enableAvpPause = ref.enableAvpPause;
   pauseBtStreaming = ref.pauseBtStreaming;
}

DeviceManagerData& DeviceManagerData::operator=(const DeviceManagerData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   name = ref.name;
   cod = ref.cod;
   info = ref.info;
   reason = ref.reason;
   secondaryInfo = ref.secondaryInfo;
   requestItem = ref.requestItem;
   timer = ref.timer;
   master = ref.master;
   powerMode = ref.powerMode;
   disconnectedByException = ref.disconnectedByException;
   retryMax = ref.retryMax;
   retryNmb = ref.retryNmb;
   waitForDisconnectedUpdate = ref.waitForDisconnectedUpdate;
   enableAvpPause = ref.enableAvpPause;
   pauseBtStreaming = ref.pauseBtStreaming;

   return *this;
}

bool DeviceManagerData::operator==(const DeviceManagerData& ref) const
{
   bool result = true;

   result = (true == result) && (name == ref.name);
   result = (true == result) && (cod == ref.cod);
   result = (true == result) && (info == ref.info);
   result = (true == result) && (reason == ref.reason);
   result = (true == result) && (secondaryInfo == ref.secondaryInfo);
   result = (true == result) && (requestItem == ref.requestItem);
   result = (true == result) && (timer == ref.timer);
   result = (true == result) && (master == ref.master);
   result = (true == result) && (powerMode == ref.powerMode);
   result = (true == result) && (disconnectedByException == ref.disconnectedByException);
   result = (true == result) && (retryMax == ref.retryMax);
   result = (true == result) && (retryNmb == ref.retryNmb);
   result = (true == result) && (waitForDisconnectedUpdate == ref.waitForDisconnectedUpdate);
   result = (true == result) && (enableAvpPause == ref.enableAvpPause);
   result = (true == result) && (pauseBtStreaming == ref.pauseBtStreaming);

   return result;
}

bool DeviceManagerData::operator!=(const DeviceManagerData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
