/**
 * @file DeviceIdServiceRecord.h
 *
 * @par SW-Component
 * State machine for device id service record
 *
 * @brief Implementation of generic device id service record state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of generic device id service record state machine.
 */

#ifndef _DEVICE_ID_SERVICE_RECORD_H_
#define _DEVICE_ID_SERVICE_RECORD_H_

#include "StateMachine.h"
#include "IDeviceIdServiceRecord.h"
#include "IDeviceIdServiceRecordCallback.h"
#include "IConfigurationClient.h"

namespace btstackif {

/**
 * DeviceIdServiceRecord class.
 */
class DeviceIdServiceRecord : public StateMachine, public IDeviceIdServiceRecord, public IDeviceIdServiceRecordCallback, public IConfigurationClient
{
public:
   /**
    * Default constructor.
    */
   DeviceIdServiceRecord();

   /**
    * Destructor.
    */
   virtual ~DeviceIdServiceRecord();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setInstance(IN IDeviceIdServiceRecordRequest* instance);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setSwitchBluetoothIf(IN ISwitchBluetooth* switchBluetooth);

   virtual void setConfigurationIf(IN IConfiguration* configurationIf);

   virtual IConfigurationClient* getConfigurationClientHandler(void);

   virtual IStateMachine* getSmEntryInterface(void);

   virtual bool isValidSetRequest(IN const App2Bts_SetDeviceIdServiceRecord& request) const;

   virtual bool setDeviceIdServiceRecord(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_SetDeviceIdServiceRecord& request);

   virtual void setDeviceIdServiceRecordResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSRequestResult result);

   virtual void setConfigurationMasterIf(IN IConfigurationMaster* master);

   virtual void startGlobalConfiguration(void);

   virtual void stopGlobalConfiguration(void);

   virtual bool isSingleConfigurationOngoing(void) const;

   virtual bool setSingleConfiguration(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const bool beforeBtOn, IN const bool errorOccurred);

private:
   IDeviceIdServiceRecordRequest* _requestIf; /**< request interface */
   IBasicControl* _controlIf; /**< basic control interface */
   ISwitchBluetooth* _switchBluetoothIf; /**< switch Bluetooth interface */
   IConfiguration* _configurationIf; /**< configuration interface */
   IConfigurationMaster* _configurationMaster; /**< configuration master interface */
   bool _globalConfigActive; /**< flag for global configuration */
   bool _configRequestOngoing; /**< flag for ongoing config request */
   bool _configRequestDone; /**< flag for finished config request */
   BTSApp2BtsMessageRequestItem _requestItem; /**< request item */

   bool isValidRecord(IN const BTSDeviceIdServiceRecord& record) const;

   void handleActionFinished(OUT BTSHandleIpc2BtsMessageItem& messageItem);

   void findApp2BtsWorkingMessage(OUT BTSHandleIpc2BtsMessageItem& messageItem);

   App2Bts_BaseMessage* getApp2BtsWorkingMessage(void);
};

} //btstackif

#endif //_DEVICE_ID_SERVICE_RECORD_H_
