/**
 * @file Configuration.h
 *
 * @par SW-Component
 * State machine for configuration
 *
 * @brief Implementation of generic configuration state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of generic configuration state machine.
 */

#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

#include "StateMachine.h"
#include "IConfiguration.h"
#include "IConfigurationMaster.h"

namespace btstackif {

// class forward declarations
class IConfigurationClient;

/**
 * Configuration class.
 */
class Configuration : public StateMachine, public IConfiguration, public IConfigurationMaster
{
public:
   /**
    * Default constructor.
    */
   Configuration();

   /**
    * Destructor.
    */
   virtual ~Configuration();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setConfiguration(IN const BTSLocalStackConfiguration& configuration);

   virtual const BTSLocalStackConfiguration& getConfiguration(void) const;

   virtual BTSLocalStackConfiguration& getConfiguration(void);

   virtual IConfigurationMaster* getConfigurationMasterHandler(void);

   virtual IStateMachine* getSmEntryInterface(void);

   virtual void setOngoing(IN const bool enable);

   virtual bool getOngoing(void) const;

   virtual void startSequence(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void continueSequence(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem);

   virtual void setError(IN const bool configurationError);

   virtual void registerConfigurationClient(IN IConfigurationClient* client, IN const bool beforeBtOn);

   virtual void start(void /*OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList*/);

   virtual void stop(void /*OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList*/);

   virtual bool doNextConfigurationStep(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem);

private:
   BTSLocalStackConfiguration _config; /**< configuration */
   ::std::vector< IConfigurationClient* > _clientListBeforeBtOn; /**< client list */
   ::std::vector< IConfigurationClient* > _clientListAfterBtOn; /**< client list */
   ::std::vector< IConfigurationClient* >::const_iterator _iteratorListBeforeBtOn; /**< iterator */
   ::std::vector< IConfigurationClient* >::const_iterator _iteratorListAfterBtOn; /**< iterator */
   bool _ongoing; /**< flag indicating ongoing configuration sequence */
   bool _errorOccurred; /**< flag indicating that an error occurred during configuration sequence */

   bool executeNextConfigurationStep(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem);

   void convertCPWSettings(void);

   void checkSppSettings(void);

   void correctConfiguration(void);

   void addAAWSettings(void);
};

} //btstackif

#endif //_CONFIGURATION_H_
