/**
 * @file BasicConfigurationItems.h
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Implementation of basic configuration items.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of basic configuration items.
 */

#ifndef _BASIC_CONFIGURATION_ITEMS_H_
#define _BASIC_CONFIGURATION_ITEMS_H_

#include "IBasicConfigurationItem.h"

namespace btstackif {

/**
 * Basic configuration item for local services.
 */
class BasicConfigurationItemLocalServices : public IBasicConfigurationItem
{
public:
   /**
    * Default constructor.
    */
   BasicConfigurationItemLocalServices();

   /**
    * Destructor.
    */
   virtual ~BasicConfigurationItemLocalServices();

   virtual void reset(void);

   virtual uint64_t getReceivedIntegerData(IN const BTSConfigurationParameter configurationParameter) const;

   virtual const ::std::string& getReceivedStringData(IN const BTSConfigurationParameter configurationParameter) const;

   virtual void setReceivedData(IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data);

   virtual void setReceivedData(IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data);

   virtual void setRequestedData(IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data);

   virtual void setRequestedData(IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data);

   virtual bool isEqual(IN const BTSConfigurationParameter configurationParameter, IN const IConfiguration& configurationIf) const;

   virtual void sendRequest(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const IConfiguration& configurationIf, IN IBasicConfigurationRequest& requestIf);

   virtual void sendVirtualUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const BTSIpcCommonErrorCode errorCode, IN IBasicConfigurationRequest& requestIf);

private:
   BTSSupportedServices _services; /**< local services */
   ::std::string _dummy; /**< dummy string */
};

/**
 * Basic configuration item for page timeout.
 */
class BasicConfigurationItemPageTimeout : public IBasicConfigurationItem
{
public:
   /**
    * Default constructor.
    */
   BasicConfigurationItemPageTimeout();

   /**
    * Destructor.
    */
   virtual ~BasicConfigurationItemPageTimeout();

   virtual void reset(void);

   virtual uint64_t getReceivedIntegerData(IN const BTSConfigurationParameter configurationParameter) const;

   virtual const ::std::string& getReceivedStringData(IN const BTSConfigurationParameter configurationParameter) const;

   virtual void setReceivedData(IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data);

   virtual void setReceivedData(IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data);

   virtual void setRequestedData(IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data);

   virtual void setRequestedData(IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data);

   virtual bool isEqual(IN const BTSConfigurationParameter configurationParameter, IN const IConfiguration& configurationIf) const;

   virtual void sendRequest(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const IConfiguration& configurationIf, IN IBasicConfigurationRequest& requestIf);

   virtual void sendVirtualUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const BTSIpcCommonErrorCode errorCode, IN IBasicConfigurationRequest& requestIf);

private:
   BTSTimeValue _pageTimeout; /**< page timeout (received value) */
   BTSTimeValue _requestedPageTimeout; /**< page timeout (requested value) */
   ::std::string _dummy; /**< dummy string */
};

} //btstackif

#endif //_BASIC_CONFIGURATION_ITEMS_H_
