/**
 * @file BasicConfigurationData.h
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Implementation of basic configuration data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of basic configuration data.
 */

#ifndef _BASIC_CONFIGURATION_DATA_H_
#define _BASIC_CONFIGURATION_DATA_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IBasicConfigurationRequest;
class IBasicConfigurationItem;
class IBasicResultCallback;

/**
 * Basic configuration data class.
 */
class BasicConfigurationData
{
public:
   /**
    * Default constructor.
    */
   BasicConfigurationData();

   /**
    * Destructor.
    */
   virtual ~BasicConfigurationData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   BasicConfigurationData(const BasicConfigurationData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   BasicConfigurationData& operator=(const BasicConfigurationData& ref);

   /**
    * Equality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator==(const BasicConfigurationData& ref) const;

   /**
    * Inequality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator!=(const BasicConfigurationData& ref) const;

   // member with public access
   IBasicConfigurationRequest* requestIf; /**< request interface */
   bool configRequestOngoing; /**< flag for ongoing config request */
   bool getRequestOngoing; /**< flag for ongoing get request */
   bool configRequestDone; /**< flag for finished config request */
   IBasicConfigurationItem* configItem; /**< configuration item */
   bool beforeBtOn; /**< flag for configuration before or after switching BT on */
   bool configureDuringStartup; /**< flag indicating that parameter shall be configured during startup */
   IBasicResultCallback* callback; /**< callback */
};

} //btstackif

#endif //_BASIC_CONFIGURATION_DATA_H_
