/**
 * @file IBluetoothStackErrorHandlingRequest.h
 *
 * @par SW-Component
 * State machine for Bluetooth stack error handling
 *
 * @brief Request interface definition for Bluetooth stack error handling state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the request interface to be implemented by specific Bluetooth stack error handling state machine.
 */

#ifndef _I_BLUETOOTH_STACK_ERROR_HANDLING_REQUEST_H_
#define _I_BLUETOOTH_STACK_ERROR_HANDLING_REQUEST_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IBluetoothStackErrorHandlingCallback;

/**
 * Interface definition.
 */
class IBluetoothStackErrorHandlingRequest
{
public:
   /**
    * Destructor.
    */
   virtual ~IBluetoothStackErrorHandlingRequest() {}

   /**
    * Reset internal data.
    */
   virtual void reset(void) = 0;

   /**
    * Set callback instance (implementation).
    *
    * @param[in] callback: callback instance (implementation)
    */
   virtual void setCallback(IN IBluetoothStackErrorHandlingCallback* callback) = 0;
};

} //btstackif

#endif //_I_BLUETOOTH_STACK_ERROR_HANDLING_REQUEST_H_
