/**
 * @file IBluetoothStackErrorHandling.h
 *
 * @par SW-Component
 * State machine for Bluetooth stack error handling
 *
 * @brief Interface definition for generic Bluetooth stack error handling state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the generic interface for Bluetooth stack error handling state machine.
 */

#ifndef _I_BLUETOOTH_STACK_ERROR_HANDLING_H_
#define _I_BLUETOOTH_STACK_ERROR_HANDLING_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IBluetoothStackErrorHandlingRequest;
class IBasicControl;
class IStateMachine;

/**
 * Interface definition.
 */
class IBluetoothStackErrorHandling
{
public:
   /**
    * Destructor.
    */
   virtual ~IBluetoothStackErrorHandling() {}

   /**
    * Set specific instance (implementation).
    *
    * @param[in] instance: instance (implementation)
    */
   virtual void setInstance(IN IBluetoothStackErrorHandlingRequest* instance) = 0;

   /**
    * Set basic control interface.
    *
    * @param[in] control: basic control interface
    */
   virtual void setControlIf(IN IBasicControl* control) = 0;

   /**
    * Get SM entry interface.
    *
    * @return = SM entry interface
    */
   virtual IStateMachine* getSmEntryInterface(void) = 0;
};

} //btstackif

#endif //_I_BLUETOOTH_STACK_ERROR_HANDLING_H_
