/**
 * @file ICheckWaitingQueue.h
 *
 * @par SW-Component
 * Check Waiting Queue Interface
 *
 * @brief Interface definition for check waiting queue.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the interface for check waiting queue.
 */

#ifndef _I_CHECK_WAITING_QUEUE_H_
#define _I_CHECK_WAITING_QUEUE_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

/**
 * Interface definition.
 */
class ICheckWaitingQueue
{
public:
   /**
    * Destructor.
    */
   virtual ~ICheckWaitingQueue() {}

   /**
    * Check waiting queue for messages that can be processed now.
    *
    * @param[in] compareItem: compare item with necessary input data
    */
   virtual void checkWaitingQueue(IN const BTSApp2BtsMessageCompareItem& compareItem) = 0;
};

} //btstackif

#endif //_I_CHECK_WAITING_QUEUE_H_
