/**
 * @file Ipc2Bts_BaseMessage.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of base message for IPC to BtStackIf messages.
 */

#include "Ipc2Bts_BaseMessage.h"
#include "BtsUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
#include "FwMemoryChecker.h"
#endif

namespace btstackif {

unsigned int Ipc2Bts_BaseMessage::_countIpc2BtsMessages = 0;

Ipc2Bts_BaseMessage::Ipc2Bts_BaseMessage()
{
   _functionBlock = BTS_COMMON_ENUM_CLASS_DEFAULT_VALUE;
   _opCode = BTS_COMMON_ENUM_CLASS_DEFAULT_VALUE;
   _btsDestinationFunctionBlock = BTS_FB_NONE;
   _app2BtsOpcode = App2BtsOC_None;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   // _objectPath is empty
   _commonErrorCode = BTS_IPC_LAST;
   _token = ::ccdbusif::DEFAULT_ACT;
   // _errorName
   // _errorMessage
   // _app2BtsCompareItem
   _isResponseMessage = false;
   // _objectId is empty
   _countIpc2BtsMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Ipc2Bts_BaseMessage::Ipc2Bts_BaseMessage(IN const BTSCommonEnumClass functionBlock, IN const BTSCommonEnumClass opCode)
{
   _functionBlock = functionBlock;
   _opCode = opCode;
   _btsDestinationFunctionBlock = BTS_FB_NONE;
   _app2BtsOpcode = App2BtsOC_None;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   // _objectPath is empty
   _commonErrorCode = BTS_IPC_LAST;
   _token = ::ccdbusif::DEFAULT_ACT;
   // _errorName
   // _errorMessage
   // _app2BtsCompareItem
   _isResponseMessage = false;
   // _objectId is empty
   _countIpc2BtsMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Ipc2Bts_BaseMessage::Ipc2Bts_BaseMessage(IN const Ipc2Bts_BaseMessage& ref)
{
   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _btsDestinationFunctionBlock = ref._btsDestinationFunctionBlock;
   _app2BtsOpcode = ref._app2BtsOpcode;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _objectPath = ref._objectPath;
   _commonErrorCode = ref._commonErrorCode;
   _token = ref._token;
   _errorName = ref._errorName;
   _errorMessage = ref._errorMessage;
   _app2BtsCompareItem = ref._app2BtsCompareItem;
   _isResponseMessage = ref._isResponseMessage;
   _objectId = ref._objectId;
   _countIpc2BtsMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Ipc2Bts_BaseMessage& Ipc2Bts_BaseMessage::operator=(IN const Ipc2Bts_BaseMessage& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _btsDestinationFunctionBlock = ref._btsDestinationFunctionBlock;
   _app2BtsOpcode = ref._app2BtsOpcode;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _objectPath = ref._objectPath;
   _commonErrorCode = ref._commonErrorCode;
   _token = ref._token;
   _errorName = ref._errorName;
   _errorMessage = ref._errorMessage;
   _app2BtsCompareItem = ref._app2BtsCompareItem;
   _isResponseMessage = ref._isResponseMessage;
   _objectId = ref._objectId;
   // do not increment --- _countIpc2BtsMessages++;

   return *this;
}

Ipc2Bts_BaseMessage::~Ipc2Bts_BaseMessage()
{
   if(_countIpc2BtsMessages) _countIpc2BtsMessages--;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_DEL_OBJ(this);
#endif
}

void Ipc2Bts_BaseMessage::doInputTrace(void)
{
   // is done by derived class
}

uint32_t Ipc2Bts_BaseMessage::getMessageTraceId(void) const
{
   return calcMessageTraceId((uint32_t)_component, (uint32_t)_stackInterface, (uint32_t)_opCode);
}

} //btstackif
