/**
 * @file BtStackIfWblRequest.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief Wbl request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of wbl request functionality.
 */

#include "BtStackIfWblRequest.h"
#include "App2Bts_MessageWrapper.h"
#include "BtsUtils.h"
#include "FwAssert.h"

namespace btstackif {

BtStackIfWblRequest::BtStackIfWblRequest(IN const BTSFunctionBlock componentFunctionBlock /*= BTS_FB_WBL*/, IN const BTSInterfaceType stackInterface /*= BTS_IF_ALPS_EVOLUTION_GENIVI*/) :
BtStackIfBaseRequest(BTS_USER_MODE_CONNECTION, componentFunctionBlock, BTS_FB_WBL, stackInterface)
{
}

BtStackIfWblRequest::BtStackIfWblRequest() :
BtStackIfBaseRequest(BTS_USER_MODE_CONNECTION, BTS_FB_WBL, BTS_FB_WBL, BTS_IF_ALPS_EVOLUTION_GENIVI)
{
   // shall not be used
   FW_NORMAL_ASSERT_ALWAYS();
}

BtStackIfWblRequest::~BtStackIfWblRequest()
{
}

void BtStackIfWblRequest::registerCallback(IBtStackIfWblCallback* callback)
{
   if(0 == callback)
   {
      return;
   }

   if(_callback.getWblCallback())
   {
      // already registered
      return;
   }

   _callback.setWblCallback(callback);
   registerInternalCallback();
}

BTSSessionHandle BtStackIfWblRequest::getSessionHandle(void) const
{
   return getHandle();
}

BTSErrorCode BtStackIfWblRequest::init(IN const BTSLocalWblConfiguration& configuration) const
{
   BTSLocalConfigurationContainer container;
   container.wblConfiguration = configuration;
   container.wblActive = true;
   return processInit(container);
}

BTSErrorCode BtStackIfWblRequest::deInit(void) const
{
   return processDeInit();
}

void BtStackIfWblRequest::setWblDummy(void)
{
   App2Bts_SetWblDummy* ptrMessage = ptrNew_App2Bts_SetWblDummy();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::allowWblCommunication(void)
{
   App2Bts_AllowWblCommunication* ptrMessage = ptrNew_App2Bts_AllowWblCommunication();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::blockWblCommunication(void)
{
   App2Bts_BlockWblCommunication* ptrMessage = ptrNew_App2Bts_BlockWblCommunication();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::getWblCommunicationStatus(void)
{
   App2Bts_GetWblCommunicationStatus* ptrMessage = ptrNew_App2Bts_GetWblCommunicationStatus();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::getWblServiceAvailability(void)
{
   App2Bts_GetWblServiceAvailability* ptrMessage = ptrNew_App2Bts_GetWblServiceAvailability();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::getWblLastIntendedMode(void)
{
   App2Bts_GetWblLastIntendedMode* ptrMessage = ptrNew_App2Bts_GetWblLastIntendedMode();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::getWblSupportedRestrictions(void)
{
   App2Bts_GetWblSupportedRestrictions* ptrMessage = ptrNew_App2Bts_GetWblSupportedRestrictions();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::getWblWiFiSetupStatus(void)
{
   App2Bts_GetWblWiFiSetupStatus* ptrMessage = ptrNew_App2Bts_GetWblWiFiSetupStatus();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::getWblHealthinessIndicator(void)
{
   App2Bts_GetWblHealthinessIndicator* ptrMessage = ptrNew_App2Bts_GetWblHealthinessIndicator();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfWblRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfWblRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfWblRequest::setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfWblRequest::setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processMainControlTestCommand(testCommand, testData);
}

void BtStackIfWblRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

void BtStackIfWblRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

} //btstackif
