/**
 * @file BtStackIfTypesTrace.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace enum to string.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace enum to string.
 * This file is completely generated by parser tooling (code generation). => DO NOT EDIT!
 */

#include "BtStackIfTypesTrace.h"

namespace btstackif {

const char* getInterfaceType2String(BTSInterfaceType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_IF_UNDEFINED:
         result = "UNDEFINED";
         break;
      case BTS_IF_SIMULATION:
         result = "SIMULATION";
         break;
      case BTS_IF_ALPS_EVOLUTION_GENIVI:
         result = "ALPS_EVOLUTION_GENIVI";
         break;
      case BTS_IF_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getUserMode2String(BTSUserMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_USER_MODE_CONNECTION:
         result = "CONNECTION";
         break;
      case BTS_USER_MODE_TELEPHONY:
         result = "TELEPHONY";
         break;
      case BTS_USER_MODE_PHONEBOOK:
         result = "PHONEBOOK";
         break;
      case BTS_USER_MODE_MESSAGING:
         result = "MESSAGING";
         break;
      case BTS_USER_MODE_MEDIAPLAYER:
         result = "MEDIAPLAYER";
         break;
      case BTS_USER_MODE_CONN_WO_AGENT:
         result = "CONN_WO_AGENT";
         break;
      case BTS_USER_MODE_ALL_WI_AGENT:
         result = "ALL_WI_AGENT";
         break;
      case BTS_USER_MODE_ALL_WO_AGENT:
         result = "ALL_WO_AGENT";
         break;
      case BTS_USER_MODE_BT_DISABLED:
         result = "BT_DISABLED";
         break;
      case BTS_USER_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getFunctionBlock2String(BTSFunctionBlock value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_FB_NONE:
         result = "NONE";
         break;
      case BTS_FB_CONFIG:
         result = "CONFIG";
         break;
      case BTS_FB_CONNECTION:
         result = "CONNECTION";
         break;
      case BTS_FB_TELEPHONY:
         result = "TELEPHONY";
         break;
      case BTS_FB_PHONEBOOK:
         result = "PHONEBOOK";
         break;
      case BTS_FB_MESSAGING:
         result = "MESSAGING";
         break;
      case BTS_FB_MEDIAPLAYER:
         result = "MEDIAPLAYER";
         break;
      case BTS_FB_WBL:
         result = "WBL";
         break;
      case BTS_FB_ECNR:
         result = "ECNR";
         break;
      case BTS_FB_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getErrorCode2String(BTSErrorCode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_OK:
         result = "OK";
         break;
      case BTS_ERROR:
         result = "ERROR";
         break;
      case BTS_LIB_NOT_INITIALIZED:
         result = "LIB_NOT_INITIALIZED";
         break;
      case BTS_INVALID_PARAM:
         result = "INVALID_PARAM";
         break;
      case BTS_BUSY:
         result = "BUSY";
         break;
      case BTS_BT_CONNECTION_EXISTS:
         result = "BT_CONNECTION_EXISTS";
         break;
      case BTS_LOCAL_REJECT:
         result = "LOCAL_REJECT";
         break;
      case BTS_QUEUE_LIMIT_REACHED:
         result = "QUEUE_LIMIT_REACHED";
         break;
      case BTS_NOT_IMPLEMENTED:
         result = "NOT_IMPLEMENTED";
         break;
      case BTS_NULL_POINTER:
         result = "NULL_POINTER";
         break;
      case BTS_INIT_ERROR:
         result = "INIT_ERROR";
         break;
      case BTS_NO_RESOURCES:
         result = "NO_RESOURCES";
         break;
      case BTS_SEMOP_ERROR:
         result = "SEMOP_ERROR";
         break;
      case BTS_TIMEOUT_ERROR:
         result = "TIMEOUT_ERROR";
         break;
      case BTS_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getProtocolId2String(BTSProtocolId value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_PROTO_HFP:
         result = "HFP";
         break;
      case BTS_PROTO_AVP:
         result = "AVP";
         break;
      case BTS_PROTO_PIM:
         result = "PIM";
         break;
      case BTS_PROTO_MSG:
         result = "MSG";
         break;
      case BTS_PROTO_DUN:
         result = "DUN";
         break;
      case BTS_PROTO_PAN:
         result = "PAN";
         break;
      case BTS_PROTO_SPP:
         result = "SPP";
         break;
      case BTS_PROTO_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBool2String(bool value)
{
   const char* result = "<Unknown>";

   if(true == value)
   {
      result = "TRUE";
   }
   else if(false == value)
   {
      result = "FALSE";
   }

   return result;
}

const char* getRequestResult2String(BTSRequestResult value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_REQ_SUCCESS:
         result = "SUCCESS";
         break;
      case BTS_REQ_FAILED:
         result = "FAILED";
         break;
      case BTS_REQ_CONNECT_PROTOCOL_FAILED:
         result = "CONNECT_PROTOCOL_FAILED";
         break;
      case BTS_REQ_CONNECT_ACL_FAILED:
         result = "CONNECT_ACL_FAILED";
         break;
      case BTS_REQ_CONNECT_ABORTED:
         result = "CONNECT_ABORTED";
         break;
      case BTS_REQ_DISCONNECT_ABORTED:
         result = "DISCONNECT_ABORTED";
         break;
      case BTS_REQ_PROTOCOL_NOT_SUPPORTED:
         result = "PROTOCOL_NOT_SUPPORTED";
         break;
      case BTS_REQ_DISCOVERY_ALREADY_STARTED:
         result = "DISCOVERY_ALREADY_STARTED";
         break;
      case BTS_REQ_PAIRING_ABORTED:
         result = "PAIRING_ABORTED";
         break;
      case BTS_REQ_PAIRING_CONN_LOST:
         result = "PAIRING_CONN_LOST";
         break;
      case BTS_REQ_PAIRING_AUTHENTICATION_ERROR:
         result = "PAIRING_AUTHENTICATION_ERROR";
         break;
      case BTS_REQ_PAIRING_PAIRING_CANCELLED:
         result = "PAIRING_PAIRING_CANCELLED";
         break;
      case BTS_REQ_PAIRING_MISSING_PIN:
         result = "PAIRING_MISSING_PIN";
         break;
      case BTS_REQ_PAIRING_UNKNOWN:
         result = "PAIRING_UNKNOWN";
         break;
      case BTS_REQ_BT_INIT_FAILED:
         result = "BT_INIT_FAILED";
         break;
      case BTS_REQ_SEARCH_NOT_STARTED:
         result = "SEARCH_NOT_STARTED";
         break;
      case BTS_REQ_SPP_UUID_NOT_FOUND:
         result = "SPP_UUID_NOT_FOUND";
         break;
      case BTS_REQ_SPP_LIMIT_REACHED:
         result = "SPP_LIMIT_REACHED";
         break;
      case BTS_REQ_DBUS_ERROR:
         result = "DBUS_ERROR";
         break;
      case BTS_REQ_CONNECT_TIMEOUT:
         result = "CONNECT_TIMEOUT";
         break;
      case BTS_REQ_CONNECT_REJECTED:
         result = "CONNECT_REJECTED";
         break;
      case BTS_REQ_INVALID_PARAM:
         result = "INVALID_PARAM";
         break;
      case BTS_REQ_NOT_CONNECTED:
         result = "NOT_CONNECTED";
         break;
      case BTS_REQ_BUSY:
         result = "BUSY";
         break;
      case BTS_REQ_PARTIAL_UPDATE:
         result = "PARTIAL_UPDATE";
         break;
      case BTS_REQ_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getConnectionStatus2String(BTSConnectionStatus value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_CONN_CONNECTED:
         result = "CONNECTED";
         break;
      case BTS_CONN_DISCONNECTED:
         result = "DISCONNECTED";
         break;
      case BTS_CONN_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDisconnectReason2String(BTSDisconnectReason value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DISCONNECT_REASON_NOT_VALID:
         result = "NOT_VALID";
         break;
      case BTS_DISCONNECT_REASON_NORMAL_LOSS_LOCAL_OR_REMOTE:
         result = "NORMAL_LOSS_LOCAL_OR_REMOTE";
         break;
      case BTS_DISCONNECT_REASON_NORMAL_LOSS_LOCAL:
         result = "NORMAL_LOSS_LOCAL";
         break;
      case BTS_DISCONNECT_REASON_NORMAL_LOSS_REMOTE:
         result = "NORMAL_LOSS_REMOTE";
         break;
      case BTS_DISCONNECT_REASON_ABNORMAL_LOSS:
         result = "ABNORMAL_LOSS";
         break;
      case BTS_DISCONNECT_REASON_ACL_CONNECT_FAILED:
         result = "ACL_CONNECT_FAILED";
         break;
      case BTS_DISCONNECT_REASON_PROTO_CONNECT_FAILED:
         result = "PROTO_CONNECT_FAILED";
         break;
      case BTS_DISCONNECT_REASON_PROTO_CONNECT_ABORTED:
         result = "PROTO_CONNECT_ABORTED";
         break;
      case BTS_DISCONNECT_REASON_PROTO_CONNECT_TIMEOUT:
         result = "PROTO_CONNECT_TIMEOUT";
         break;
      case BTS_DISCONNECT_REASON_PROTO_CONNECT_REJECTED:
         result = "PROTO_CONNECT_REJECTED";
         break;
      case BTS_DISCONNECT_REASON_PROTO_NOT_SUPPORTED:
         result = "PROTO_NOT_SUPPORTED";
         break;
      case BTS_DISCONNECT_REASON_SPP_UUID_NOT_FOUND:
         result = "SPP_UUID_NOT_FOUND";
         break;
      case BTS_DISCONNECT_REASON_SPP_LIMIT_REACHED:
         result = "SPP_LIMIT_REACHED";
         break;
      case BTS_DISCONNECT_REASON_MISSING_LINK_KEY:
         result = "MISSING_LINK_KEY";
         break;
      case BTS_DISCONNECT_REASON_OUT_OF_RANGE:
         result = "OUT_OF_RANGE";
         break;
      case BTS_DISCONNECT_REASON_CONFLICT_DIFFERENT_DEVICE:
         result = "CONFLICT_DIFFERENT_DEVICE";
         break;
      case BTS_DISCONNECT_REASON_CONFLICT_SAME_DEVICE:
         result = "CONFLICT_SAME_DEVICE";
         break;
      case BTS_DISCONNECT_REASON_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getPairConnectOriginator2String(BTSPairConnectOriginator value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_PAIR_CONNECT_INITIATED_BY_LOCAL_DEVICE:
         result = "BY_LOCAL_DEVICE";
         break;
      case BTS_PAIR_CONNECT_INITIATED_BY_REMOTE_DEVICE:
         result = "BY_REMOTE_DEVICE";
         break;
      case BTS_PAIR_CONNECT_INITIATED_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getSspMode2String(BTSSspMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SSP_WITH_NUMERIC_COMPARISON:
         result = "WITH_NUMERIC_COMPARISON";
         break;
      case BTS_SSP_WITH_JUST_WORK_MODE:
         result = "WITH_JUST_WORK_MODE";
         break;
      case BTS_SSP_WITH_PASSKEY_ENTRY_MODE_INPUT_BY_REMOTE_DEVICE:
         result = "WITH_PASSKEY_ENTRY_MODE_INPUT_BY_REMOTE_DEVICE";
         break;
      case BTS_SSP_WITH_PASSKEY_ENTRY_MODE_INPUT_BY_LOCAL_DEVICE:
         result = "WITH_PASSKEY_ENTRY_MODE_INPUT_BY_LOCAL_DEVICE";
         break;
      case BTS_SSP_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getConfirmationMode2String(BTSConfirmationMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_CONFIRM_REJECT:
         result = "REJECT";
         break;
      case BTS_CONFIRM_ACCEPT:
         result = "ACCEPT";
         break;
      case BTS_CONFIRM_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getLocalMode2String(BTSLocalMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_MODE_DISABLED:
         result = "DISABLED";
         break;
      case BTS_MODE_ENABLED:
         result = "ENABLED";
         break;
      case BTS_MODE_UNCHANGED:
         result = "UNCHANGED";
         break;
      case BTS_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDiscoveringStatus2String(BTSDiscoveringStatus value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DISCOVERING_OFF:
         result = "OFF";
         break;
      case BTS_DISCOVERING_ON:
         result = "ON";
         break;
      case BTS_DISCOVERING_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBluetoothMode2String(BTSBluetoothMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_MODE_OFF:
         result = "OFF";
         break;
      case BTS_BT_MODE_ON:
         result = "ON";
         break;
      case BTS_BT_MODE_RF_TEST_MODE:
         result = "RF_TEST_MODE";
         break;
      case BTS_BT_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBluetoothOffReason2String(BTSBluetoothOffReason value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_OFF_REASON_NOT_VALID:
         result = "NOT_VALID";
         break;
      case BTS_BT_OFF_REASON_APP_REQUESTED:
         result = "APP_REQUESTED";
         break;
      case BTS_BT_OFF_REASON_STARTUP:
         result = "STARTUP";
         break;
      case BTS_BT_OFF_REASON_STACK_NOT_RUNNING:
         result = "STACK_NOT_RUNNING";
         break;
      case BTS_BT_OFF_REASON_DBUS_ERROR:
         result = "DBUS_ERROR";
         break;
      case BTS_BT_OFF_REASON_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getAgentCapability2String(BTSAgentCapability value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_AGENT_CAPABILITY_DISPLAY_YES_NO:
         result = "DISPLAY_YES_NO";
         break;
      case BTS_AGENT_CAPABILITY_DISPLAY_ONLY:
         result = "DISPLAY_ONLY";
         break;
      case BTS_AGENT_CAPABILITY_KEYBOARD_ONLY:
         result = "KEYBOARD_ONLY";
         break;
      case BTS_AGENT_CAPABILITY_NO_INPUT_NO_OUTPUT:
         result = "NO_INPUT_NO_OUTPUT";
         break;
      case BTS_AGENT_CAPABILITY_KEYBOARD_DISPLAY:
         result = "KEYBOARD_DISPLAY";
         break;
      case BTS_AGENT_CAPABILITY_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getAdapterMode2String(BTSAdapterMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_ADAPTER_MODE_APP:
         result = "APP";
         break;
      case BTS_ADAPTER_MODE_HCI:
         result = "HCI";
         break;
      case BTS_ADAPTER_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getLinkKeyType2String(BTSLinkKeyType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_LINK_KEY_TYPE_COMBINATION_KEY:
         result = "COMBINATION_KEY";
         break;
      case BTS_LINK_KEY_TYPE_LOCAL_UNIT_KEY:
         result = "LOCAL_UNIT_KEY";
         break;
      case BTS_LINK_KEY_TYPE_REMOTE_UNIT_KEY:
         result = "REMOTE_UNIT_KEY";
         break;
      case BTS_LINK_KEY_TYPE_DEBUG_COMBINATION_KEY:
         result = "DEBUG_COMBINATION_KEY";
         break;
      case BTS_LINK_KEY_TYPE_UNAUTHENTICATED_COMBINATION_KEY:
         result = "UNAUTHENTICATED_COMBINATION_KEY";
         break;
      case BTS_LINK_KEY_TYPE_AUTHENTICATED_COMBINATION_KEY:
         result = "AUTHENTICATED_COMBINATION_KEY";
         break;
      case BTS_LINK_KEY_TYPE_CHANGED_COMBINATION_KEY:
         result = "CHANGED_COMBINATION_KEY";
         break;
      case BTS_LINK_KEY_TYPE_UNKNOWN:
         result = "UNKNOWN";
         break;
      case BTS_LINK_KEY_TYPE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getMajorServiceClassBit2String(BTSMajorServiceClassBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_COD_MSC_LIMITED_DISCOVERABLE_MODE:
         result = "LIMITED_DISCOVERABLE_MODE";
         break;
      case BTS_COD_MSC_POSITIONING:
         result = "POSITIONING";
         break;
      case BTS_COD_MSC_NETWORKING:
         result = "NETWORKING";
         break;
      case BTS_COD_MSC_RENDERING:
         result = "RENDERING";
         break;
      case BTS_COD_MSC_CAPTURING:
         result = "CAPTURING";
         break;
      case BTS_COD_MSC_OBJECT_TRANSFER:
         result = "OBJECT_TRANSFER";
         break;
      case BTS_COD_MSC_AUDIO:
         result = "AUDIO";
         break;
      case BTS_COD_MSC_TELEPHONY:
         result = "TELEPHONY";
         break;
      case BTS_COD_MSC_INFORMATION:
         result = "INFORMATION";
         break;
      case BTS_COD_MSC_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getMajorDeviceClass2String(BTSMajorDeviceClass value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_COD_MAJORDC_MISCELLANEOUS:
         result = "MISCELLANEOUS";
         break;
      case BTS_COD_MAJORDC_COMPUTER:
         result = "COMPUTER";
         break;
      case BTS_COD_MAJORDC_PHONE:
         result = "PHONE";
         break;
      case BTS_COD_MAJORDC_LAN:
         result = "LAN";
         break;
      case BTS_COD_MAJORDC_AUDIO:
         result = "AUDIO";
         break;
      case BTS_COD_MAJORDC_PERIPHERAL:
         result = "PERIPHERAL";
         break;
      case BTS_COD_MAJORDC_IMAGING:
         result = "IMAGING";
         break;
      case BTS_COD_MAJORDC_WEARABLE:
         result = "WEARABLE";
         break;
      case BTS_COD_MAJORDC_TOY:
         result = "TOY";
         break;
      case BTS_COD_MAJORDC_HEALTH:
         result = "HEALTH";
         break;
      case BTS_COD_MAJORDC_UNCATEGORIZED:
         result = "UNCATEGORIZED";
         break;
      case BTS_COD_MAJORDC_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getMinorDeviceClass2String(BTSMinorDeviceClass value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_COD_MINORDC_UNCATEGORIZED:
         result = "UNCATEGORIZED";
         break;
      case BTS_COD_MINORDC_DESKTOP:
         result = "DESKTOP";
         break;
      case BTS_COD_MINORDC_SERVER:
         result = "SERVER";
         break;
      case BTS_COD_MINORDC_LAPTOP:
         result = "LAPTOP";
         break;
      case BTS_COD_MINORDC_HANDHELD:
         result = "HANDHELD";
         break;
      case BTS_COD_MINORDC_PALM:
         result = "PALM";
         break;
      case BTS_COD_MINORDC_WEARABLE:
         result = "WEARABLE";
         break;
      case BTS_COD_MINORDC_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getSearchType2String(BTSSearchType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SEARCH_ALL:
         result = "ALL";
         break;
      case BTS_SEARCH_SPP:
         result = "SPP";
         break;
      case BTS_SEARCH_DID:
         result = "DID";
         break;
      case BTS_SEARCH_PBAP:
         result = "PBAP";
         break;
      case BTS_SEARCH_MAP:
         result = "MAP";
         break;
      case BTS_SEARCH_PAN:
         result = "PAN";
         break;
      case BTS_SEARCH_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getSupportedServicesBit2String(BTSSupportedServicesBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SUPP_SRV_HFP:
         result = "HFP";
         break;
      case BTS_SUPP_SRV_A2DP:
         result = "A2DP";
         break;
      case BTS_SUPP_SRV_AVRCP:
         result = "AVRCP";
         break;
      case BTS_SUPP_SRV_PBAP:
         result = "PBAP";
         break;
      case BTS_SUPP_SRV_MAP:
         result = "MAP";
         break;
      case BTS_SUPP_SRV_DUN:
         result = "DUN";
         break;
      case BTS_SUPP_SRV_PAN:
         result = "PAN";
         break;
      case BTS_SUPP_SRV_SPP:
         result = "SPP";
         break;
      case BTS_SUPP_SRV_PNP:
         result = "PNP";
         break;
      case BTS_SUPP_SRV_DID:
         result = "DID";
         break;
      case BTS_SUPP_SRV_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getLocalModeOffReason2String(BTSLocalModeOffReason value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_MODE_OFF_REASON_NOT_VALID:
         result = "NOT_VALID";
         break;
      case BTS_MODE_OFF_REASON_APP_REQUESTED:
         result = "APP_REQUESTED";
         break;
      case BTS_MODE_OFF_REASON_TIMEOUT:
         result = "TIMEOUT";
         break;
      case BTS_MODE_OFF_REASON_INTERNAL:
         result = "INTERNAL";
         break;
      case BTS_MODE_OFF_REASON_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBtCoreVersion2String(BTSBtCoreVersion value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_CORE_1_0_B:
         result = "1_0_B";
         break;
      case BTS_BT_CORE_1_1:
         result = "1_1";
         break;
      case BTS_BT_CORE_1_2:
         result = "1_2";
         break;
      case BTS_BT_CORE_2_0_EDR:
         result = "2_0_EDR";
         break;
      case BTS_BT_CORE_2_1_EDR:
         result = "2_1_EDR";
         break;
      case BTS_BT_CORE_3_0_HS:
         result = "3_0_HS";
         break;
      case BTS_BT_CORE_4_0:
         result = "4_0";
         break;
      case BTS_BT_CORE_4_1:
         result = "4_1";
         break;
      case BTS_BT_CORE_4_2:
         result = "4_2";
         break;
      case BTS_BT_CORE_5_0:
         result = "5_0";
         break;
      case BTS_BT_CORE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblWifiFrequency2String(BTSWblWifiFrequency value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_WIFI_FREQUENCY_2_4_GHZ:
         result = "2_4_GHZ";
         break;
      case BTS_WBL_WIFI_FREQUENCY_5_GHZ:
         result = "5_GHZ";
         break;
      case BTS_WBL_WIFI_FREQUENCY_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblAccessPointConfigType2String(BTSWblAccessPointConfigType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_AP_CONFIG_NORMAL:
         result = "NORMAL";
         break;
      case BTS_WBL_AP_CONFIG_CPW:
         result = "CPW";
         break;
      case BTS_WBL_AP_CONFIG_AA:
         result = "AA";
         break;
      case BTS_WBL_AP_CONFIG_UNKNOWN:
         result = "UNKNOWN";
         break;
      case BTS_WBL_AP_CONFIG_RESTRICTED:
         result = "RESTRICTED";
         break;
      case BTS_WBL_AP_CONFIG_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblWifiPowerState2String(BTSWblWifiPowerState value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_WIFI_STATE_DEVICE_UNAVAILABLE:
         result = "DEVICE_UNAVAILABLE";
         break;
      case BTS_WBL_WIFI_STATE_DEVICE_AVAILABLE:
         result = "DEVICE_AVAILABLE";
         break;
      case BTS_WBL_WIFI_STATE_POWERING_ON:
         result = "POWERING_ON";
         break;
      case BTS_WBL_WIFI_STATE_POWERED_ON:
         result = "POWERED_ON";
         break;
      case BTS_WBL_WIFI_STATE_POWERING_OFF:
         result = "POWERING_OFF";
         break;
      case BTS_WBL_WIFI_STATE_POWERED_OFF:
         result = "POWERED_OFF";
         break;
      case BTS_WBL_WIFI_STATE_POWER_FAILURE:
         result = "POWER_FAILURE";
         break;
      case BTS_WBL_WIFI_STATE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblWifiMode2String(BTSWblWifiMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_WIFI_MODE_STA:
         result = "STA";
         break;
      case BTS_WBL_WIFI_MODE_AP:
         result = "AP";
         break;
      case BTS_WBL_WIFI_MODE_P2P:
         result = "P2P";
         break;
      case BTS_WBL_WIFI_MODE_ALL:
         result = "ALL";
         break;
      case BTS_WBL_WIFI_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblSupportedSetting2String(BTSWblSupportedSetting value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_SUPPORTED_SETTING_NOT_ALLOWED:
         result = "NOT_ALLOWED";
         break;
      case BTS_WBL_SUPPORTED_SETTING_ALLOWED:
         result = "ALLOWED";
         break;
      case BTS_WBL_SUPPORTED_SETTING_ALLOWED_WITH_LIMITATIONS:
         result = "ALLOWED_WITH_LIMITATIONS";
         break;
      case BTS_WBL_SUPPORTED_SETTING_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblRestrictionAction2String(BTSWblRestrictionAction value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_RESTRICTION_ACTION_DEACTIVATE:
         result = "DEACTIVATE";
         break;
      case BTS_WBL_RESTRICTION_ACTION_ACTIVATE:
         result = "ACTIVATE";
         break;
      case BTS_WBL_RESTRICTION_ACTION_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblRestrictionState2String(BTSWblRestrictionState value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_WBL_RESTRICTION_STATE_REQUESTED:
         result = "REQUESTED";
         break;
      case BTS_WBL_RESTRICTION_STATE_ACTIVATING:
         result = "ACTIVATING";
         break;
      case BTS_WBL_RESTRICTION_STATE_ACTIVATED:
         result = "ACTIVATED";
         break;
      case BTS_WBL_RESTRICTION_STATE_DEACTIVATING:
         result = "DEACTIVATING";
         break;
      case BTS_WBL_RESTRICTION_STATE_DEACTIVATED:
         result = "DEACTIVATED";
         break;
      case BTS_WBL_RESTRICTION_STATE_FAILED:
         result = "FAILED";
         break;
      case BTS_WBL_RESTRICTION_STATE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getPbapSupportedRepositoriesBit2String(BTSPbapSupportedRepositoriesBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_PBAP_REPO_LOCAL_PHONEBOOK:
         result = "LOCAL_PHONEBOOK";
         break;
      case BTS_PBAP_REPO_SIM_CARD:
         result = "SIM_CARD";
         break;
      case BTS_PBAP_REPO_SPEED_DIAL:
         result = "SPEED_DIAL";
         break;
      case BTS_PBAP_REPO_FAVORITES:
         result = "FAVORITES";
         break;
      case BTS_PBAP_REPO_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getPbapSupportedFeaturesBit2String(BTSPbapSupportedFeaturesBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_PBAP_FEA_DOWNLOAD:
         result = "DOWNLOAD";
         break;
      case BTS_PBAP_FEA_BROWSING:
         result = "BROWSING";
         break;
      case BTS_PBAP_FEA_DATABASE_IDENTIFIER:
         result = "DATABASE_IDENTIFIER";
         break;
      case BTS_PBAP_FEA_FOLDER_VERSION_COUNTERS:
         result = "FOLDER_VERSION_COUNTERS";
         break;
      case BTS_PBAP_FEA_VCARD_SELECTING:
         result = "VCARD_SELECTING";
         break;
      case BTS_PBAP_FEA_ENHANCED_MISSED_CALLS:
         result = "ENHANCED_MISSED_CALLS";
         break;
      case BTS_PBAP_FEA_X_BT_UCI_VCARD_PROPERTY:
         result = "X_BT_UCI_VCARD_PROPERTY";
         break;
      case BTS_PBAP_FEA_X_BT_UID_VCARD_PROPERTY:
         result = "X_BT_UID_VCARD_PROPERTY";
         break;
      case BTS_PBAP_FEA_CONTACT_REFERENCING:
         result = "CONTACT_REFERENCING";
         break;
      case BTS_PBAP_FEA_DEFAULT_CONTACT_IMAGE_FORMAT:
         result = "DEFAULT_CONTACT_IMAGE_FORMAT";
         break;
      case BTS_PBAP_FEA_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getMapSupportedMessageTypesBit2String(BTSMapSupportedMessageTypesBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_MAP_MSG_TYPE_EMAIL:
         result = "EMAIL";
         break;
      case BTS_MAP_MSG_TYPE_SMS_GSM:
         result = "SMS_GSM";
         break;
      case BTS_MAP_MSG_TYPE_SMS_CDMA:
         result = "SMS_CDMA";
         break;
      case BTS_MAP_MSG_TYPE_MMS:
         result = "MMS";
         break;
      case BTS_MAP_MSG_TYPE_IM:
         result = "IM";
         break;
      case BTS_MAP_MSG_TYPE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getMapSupportedFeaturesBit2String(BTSMapSupportedFeaturesBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_MAP_FEA_NOTIFICATION_REGISTRATION:
         result = "NOTIFICATION_REGISTRATION";
         break;
      case BTS_MAP_FEA_NOTIFICATION:
         result = "NOTIFICATION";
         break;
      case BTS_MAP_FEA_BROWSING:
         result = "BROWSING";
         break;
      case BTS_MAP_FEA_UPLOADING:
         result = "UPLOADING";
         break;
      case BTS_MAP_FEA_DELETE:
         result = "DELETE";
         break;
      case BTS_MAP_FEA_INSTANCE_INFORMATION:
         result = "INSTANCE_INFORMATION";
         break;
      case BTS_MAP_FEA_EXTENDED_EVENT_REPORT_1_1:
         result = "EXTENDED_EVENT_REPORT_1_1";
         break;
      case BTS_MAP_FEA_EVENT_REPORT_VERSION_1_2:
         result = "EVENT_REPORT_VERSION_1_2";
         break;
      case BTS_MAP_FEA_MESSAGE_FORMAT_VERSION_1_1:
         result = "MESSAGE_FORMAT_VERSION_1_1";
         break;
      case BTS_MAP_FEA_MESSAGES_LISTING_FORMAT_VERSION_1_1:
         result = "MESSAGES_LISTING_FORMAT_VERSION_1_1";
         break;
      case BTS_MAP_FEA_PERSISTENT_MESSAGE_HANDLES:
         result = "PERSISTENT_MESSAGE_HANDLES";
         break;
      case BTS_MAP_FEA_DATABASE_IDENTIFIER:
         result = "DATABASE_IDENTIFIER";
         break;
      case BTS_MAP_FEA_FOLDER_VERSION_COUNTER:
         result = "FOLDER_VERSION_COUNTER";
         break;
      case BTS_MAP_FEA_CONVERSATION_VERSION_COUNTERS:
         result = "CONVERSATION_VERSION_COUNTERS";
         break;
      case BTS_MAP_FEA_PARTICIPANT_PRESENCE_CHANGE_NOTIFICATION:
         result = "PARTICIPANT_PRESENCE_CHANGE_NOTIFICATION";
         break;
      case BTS_MAP_FEA_PARTICIPANT_CHAT_STATE_CHANGE_NOTIFICATION:
         result = "PARTICIPANT_CHAT_STATE_CHANGE_NOTIFICATION";
         break;
      case BTS_MAP_FEA_PBAP_CONTACT_CROSS_REFERENCE:
         result = "PBAP_CONTACT_CROSS_REFERENCE";
         break;
      case BTS_MAP_FEA_NOTIFICATION_FILTERING:
         result = "NOTIFICATION_FILTERING";
         break;
      case BTS_MAP_FEA_UTC_OFFSET_TIMESTAMP_FORMAT:
         result = "UTC_OFFSET_TIMESTAMP_FORMAT";
         break;
      case BTS_MAP_FEA_MAP_SUPPORTED_FEATURES_IN_CONNECT_REQUEST:
         result = "MAP_SUPPORTED_FEATURES_IN_CONNECT_REQUEST";
         break;
      case BTS_MAP_FEA_CONVERSATION_LISTING:
         result = "CONVERSATION_LISTING";
         break;
      case BTS_MAP_FEA_OWNER_STATUS:
         result = "OWNER_STATUS";
         break;
      case BTS_MAP_FEA_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getHciChipVendorId2String(BTSHciChipVendorId value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_HCI_CHIP_VENDOR_UNKNOWN:
         result = "UNKNOWN";
         break;
      case BTS_HCI_CHIP_VENDOR_MARVELL:
         result = "MARVELL";
         break;
      case BTS_HCI_CHIP_VENDOR_CSR:
         result = "CSR";
         break;
      case BTS_HCI_CHIP_VENDOR_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBtModuleId2String(BTSBtModuleId value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_MODULE_UNKNOWN:
         result = "UNKNOWN";
         break;
      case BTS_BT_MODULE_UGXZE_104A:
         result = "UGXZE_104A";
         break;
      case BTS_BT_MODULE_UGXZE_304A:
         result = "UGXZE_304A";
         break;
      case BTS_BT_MODULE_UGKZ2_H:
         result = "UGKZ2_H";
         break;
      case BTS_BT_MODULE_UGKZ2_E:
         result = "UGKZ2_E";
         break;
      case BTS_BT_MODULE_UGKZ2_2:
         result = "UGKZ2_2";
         break;
      case BTS_BT_MODULE_UGKZ7:
         result = "UGKZ7";
         break;
      case BTS_BT_MODULE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

} //btstackif
