/**
 * @file BtStackIfPhonebookRequest.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief Phonebook request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of phonebook request functionality.
 */

#include "BtStackIfPhonebookRequest.h"
#include "App2Bts_MessageWrapper.h"
#include "BtsUtils.h"
#include "FwAssert.h"

namespace btstackif {

BtStackIfPhonebookRequest::BtStackIfPhonebookRequest(IN const BTSFunctionBlock componentFunctionBlock /*= BTS_FB_PHONEBOOK*/, IN const BTSInterfaceType stackInterface /*= BTS_IF_ALPS_EVOLUTION_GENIVI*/) :
BtStackIfBaseRequest(BTS_USER_MODE_PHONEBOOK, componentFunctionBlock, BTS_FB_PHONEBOOK, stackInterface)
{
}

BtStackIfPhonebookRequest::BtStackIfPhonebookRequest() :
BtStackIfBaseRequest(BTS_USER_MODE_PHONEBOOK, BTS_FB_PHONEBOOK, BTS_FB_PHONEBOOK, BTS_IF_ALPS_EVOLUTION_GENIVI)
{
   // shall not be used
   FW_NORMAL_ASSERT_ALWAYS();
}

BtStackIfPhonebookRequest::~BtStackIfPhonebookRequest()
{
}

void BtStackIfPhonebookRequest::registerCallback(IBtStackIfPhonebookCallback* callback)
{
   if(0 == callback)
   {
      return;
   }

   if(_callback.getPhonebookCallback())
   {
      // already registered
      return;
   }

   _callback.setPhonebookCallback(callback);
   registerInternalCallback();
}

BTSSessionHandle BtStackIfPhonebookRequest::getSessionHandle(void) const
{
   return getHandle();
}

BTSErrorCode BtStackIfPhonebookRequest::init(IN const BTSLocalPhonebookConfiguration& configuration) const
{
   BTSLocalConfigurationContainer container;
   container.phonebookConfiguration = configuration;
   container.phonebookActive = true;
   return processInit(container);
}

BTSErrorCode BtStackIfPhonebookRequest::deInit(void) const
{
   return processDeInit();
}

void BtStackIfPhonebookRequest::setPhonebookDummy(void)
{
   App2Bts_SetPhonebookDummy* ptrMessage = ptrNew_App2Bts_SetPhonebookDummy();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfPhonebookRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfPhonebookRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfPhonebookRequest::setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfPhonebookRequest::setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processMainControlTestCommand(testCommand, testData);
}

void BtStackIfPhonebookRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

void BtStackIfPhonebookRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

} //btstackif
