/**
 * @file BtStackIfMessagingRequest.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief Messaging request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messaging request functionality.
 */

#include "BtStackIfMessagingRequest.h"
#include "App2Bts_MessageWrapper.h"
#include "BtsUtils.h"
#include "FwAssert.h"

namespace btstackif {

BtStackIfMessagingRequest::BtStackIfMessagingRequest(IN const BTSFunctionBlock componentFunctionBlock /*= BTS_FB_MESSAGING*/, IN const BTSInterfaceType stackInterface /*= BTS_IF_ALPS_EVOLUTION_GENIVI*/) :
BtStackIfBaseRequest(BTS_USER_MODE_MESSAGING, componentFunctionBlock, BTS_FB_MESSAGING, stackInterface)
{
}

BtStackIfMessagingRequest::BtStackIfMessagingRequest() :
BtStackIfBaseRequest(BTS_USER_MODE_MESSAGING, BTS_FB_MESSAGING, BTS_FB_MESSAGING, BTS_IF_ALPS_EVOLUTION_GENIVI)
{
   // shall not be used
   FW_NORMAL_ASSERT_ALWAYS();
}

BtStackIfMessagingRequest::~BtStackIfMessagingRequest()
{
}

void BtStackIfMessagingRequest::registerCallback(IBtStackIfMessagingCallback* callback)
{
   if(0 == callback)
   {
      return;
   }

   if(_callback.getMessagingCallback())
   {
      // already registered
      return;
   }

   _callback.setMessagingCallback(callback);
   registerInternalCallback();
}

BTSSessionHandle BtStackIfMessagingRequest::getSessionHandle(void) const
{
   return getHandle();
}

BTSErrorCode BtStackIfMessagingRequest::init(IN const BTSLocalMessagingConfiguration& configuration) const
{
   BTSLocalConfigurationContainer container;
   container.messagingConfiguration = configuration;
   container.messagingActive = true;
   return processInit(container);
}

BTSErrorCode BtStackIfMessagingRequest::deInit(void) const
{
   return processDeInit();
}

void BtStackIfMessagingRequest::setMessagingDummy(void)
{
   App2Bts_SetMessagingDummy* ptrMessage = ptrNew_App2Bts_SetMessagingDummy();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfMessagingRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfMessagingRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfMessagingRequest::setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfMessagingRequest::setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processMainControlTestCommand(testCommand, testData);
}

void BtStackIfMessagingRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

void BtStackIfMessagingRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

} //btstackif
