/**
 * @file BtStackIfMediaPlayerRequest.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief MediaPlayer request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of mediaplayer request functionality.
 */

#include "BtStackIfMediaPlayerRequest.h"
#include "App2Bts_MessageWrapper.h"
#include "BtsUtils.h"
#include "FwAssert.h"

namespace btstackif {

BtStackIfMediaPlayerRequest::BtStackIfMediaPlayerRequest(IN const BTSFunctionBlock componentFunctionBlock /*= BTS_FB_MEDIAPLAYER*/, IN const BTSInterfaceType stackInterface /*= BTS_IF_ALPS_EVOLUTION_GENIVI*/) :
BtStackIfBaseRequest(BTS_USER_MODE_MEDIAPLAYER, componentFunctionBlock, BTS_FB_MEDIAPLAYER, stackInterface)
{
}

BtStackIfMediaPlayerRequest::BtStackIfMediaPlayerRequest() :
BtStackIfBaseRequest(BTS_USER_MODE_MEDIAPLAYER, BTS_FB_MEDIAPLAYER, BTS_FB_MEDIAPLAYER, BTS_IF_ALPS_EVOLUTION_GENIVI)
{
   // shall not be used
   FW_NORMAL_ASSERT_ALWAYS();
}

BtStackIfMediaPlayerRequest::~BtStackIfMediaPlayerRequest()
{
}

void BtStackIfMediaPlayerRequest::registerCallback(IBtStackIfMediaPlayerCallback* callback)
{
   if(0 == callback)
   {
      return;
   }

   if(_callback.getMediaPlayerCallback())
   {
      // already registered
      return;
   }

   _callback.setMediaPlayerCallback(callback);
   registerInternalCallback();
}

BTSSessionHandle BtStackIfMediaPlayerRequest::getSessionHandle(void) const
{
   return getHandle();
}

BTSErrorCode BtStackIfMediaPlayerRequest::init(IN const BTSLocalMediaPlayerConfiguration& configuration) const
{
   BTSLocalConfigurationContainer container;
   container.mediaPlayerConfiguration = configuration;
   container.mediaPlayerActive = true;
   return processInit(container);
}

BTSErrorCode BtStackIfMediaPlayerRequest::deInit(void) const
{
   return processDeInit();
}

void BtStackIfMediaPlayerRequest::setMediaPlayerDummy(void)
{
   App2Bts_SetMediaPlayerDummy* ptrMessage = ptrNew_App2Bts_SetMediaPlayerDummy();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfMediaPlayerRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfMediaPlayerRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfMediaPlayerRequest::setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfMediaPlayerRequest::setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processMainControlTestCommand(testCommand, testData);
}

void BtStackIfMediaPlayerRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

void BtStackIfMediaPlayerRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

} //btstackif
