/**
 * @file IBtStackIfTelephonyCallback.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Telephony callback interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for telephony callback functionality.
 */

#ifndef _I_BT_STACK_IF_TELEPHONY_CALLBACK_H_
#define _I_BT_STACK_IF_TELEPHONY_CALLBACK_H_

#include "BtStackIfTypes.h"

namespace btstackif {

/**
 *
 */
class IBtStackIfTelephonyCallback
{
public:
   virtual ~IBtStackIfTelephonyCallback() {}

   /**************************************************************************
    Telephony management related interfaces
    **************************************************************************/
   virtual void fbTelephonyInitializedCB(IN const BTSRequestResult result) = 0;

   virtual void setTelephonyDummyResultCB(IN const BTSRequestResult result) = 0;
};

} //btstackif

#endif //_I_BT_STACK_IF_TELEPHONY_CALLBACK_H_
