/**
 * @file BtStackIfWblRequest.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Wbl request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for wbl request functionality.
 */

#ifndef _BT_STACK_IF_WBL_REQUEST_H_
#define _BT_STACK_IF_WBL_REQUEST_H_

#include "BtStackIfBaseRequest.h"
#include "IBtStackIfWblRequest.h"

namespace btstackif {

/**
 *
 */
class BtStackIfWblRequest : public BtStackIfBaseRequest, public IBtStackIfWblRequest
{
public:
   /**
    * Constructor.
    *
    * @param[in] componentFunctionBlock: function block related to general component functionality
    * @param[in] stackInterface: stack interface to be used (Bluetooth stack)
    */
   BtStackIfWblRequest(IN const BTSFunctionBlock componentFunctionBlock = BTS_FB_WBL, IN const BTSInterfaceType stackInterface = BTS_IF_ALPS_EVOLUTION_GENIVI);

   /**
    * Destructor.
    */
   virtual ~BtStackIfWblRequest();

   virtual void registerCallback(IBtStackIfWblCallback* callback);

   virtual BTSSessionHandle getSessionHandle(void) const;

   virtual BTSErrorCode init(IN const BTSLocalWblConfiguration& configuration) const;

   virtual BTSErrorCode deInit(void) const;

   virtual void setWblDummy(void);

   virtual void allowWblCommunication(void);

   virtual void blockWblCommunication(void);

   virtual void getWblCommunicationStatus(void);

   virtual void getWblServiceAvailability(void);

   virtual void getWblLastIntendedMode(void);

   virtual void getWblSupportedRestrictions(void);

   virtual void getWblWiFiSetupStatus(void);

   virtual void getWblHealthinessIndicator(void);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const;

   virtual void setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

private:
   /**
    * Default constructor.
    */
   BtStackIfWblRequest();
};

} //btstackif

#endif //_BT_STACK_IF_WBL_REQUEST_H_
