/**
 * @file BtStackIfTelephonyRequest.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Telephony request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for telephony request functionality.
 */

#ifndef _BT_STACK_IF_TELEPHONY_REQUEST_H_
#define _BT_STACK_IF_TELEPHONY_REQUEST_H_

#include "BtStackIfBaseRequest.h"
#include "IBtStackIfTelephonyRequest.h"

namespace btstackif {

/**
 *
 */
class BtStackIfTelephonyRequest : public BtStackIfBaseRequest, public IBtStackIfTelephonyRequest
{
public:
   /**
    * Constructor.
    *
    * @param[in] componentFunctionBlock: function block related to general component functionality
    * @param[in] stackInterface: stack interface to be used (Bluetooth stack)
    */
   BtStackIfTelephonyRequest(IN const BTSFunctionBlock componentFunctionBlock = BTS_FB_TELEPHONY, IN const BTSInterfaceType stackInterface = BTS_IF_ALPS_EVOLUTION_GENIVI);

   /**
    * Destructor.
    */
   virtual ~BtStackIfTelephonyRequest();

   virtual void registerCallback(IBtStackIfTelephonyCallback* callback);

   virtual BTSSessionHandle getSessionHandle(void) const;

   virtual BTSErrorCode init(IN const BTSLocalTelephonyConfiguration& configuration) const;

   virtual BTSErrorCode deInit(void) const;

   virtual void setTelephonyDummy(void);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const;

   virtual void setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

private:
   /**
    * Default constructor.
    */
   BtStackIfTelephonyRequest();
};

} //btstackif

#endif //_BT_STACK_IF_TELEPHONY_REQUEST_H_
