/**
 * @file BtStackIfPhonebookRequest.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Phonebook request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for phonebook request functionality.
 */

#ifndef _BT_STACK_IF_PHONEBOOK_REQUEST_H_
#define _BT_STACK_IF_PHONEBOOK_REQUEST_H_

#include "BtStackIfBaseRequest.h"
#include "IBtStackIfPhonebookRequest.h"

namespace btstackif {

/**
 *
 */
class BtStackIfPhonebookRequest : public BtStackIfBaseRequest, public IBtStackIfPhonebookRequest
{
public:
   /**
    * Constructor.
    *
    * @param[in] componentFunctionBlock: function block related to general component functionality
    * @param[in] stackInterface: stack interface to be used (Bluetooth stack)
    */
   BtStackIfPhonebookRequest(IN const BTSFunctionBlock componentFunctionBlock = BTS_FB_PHONEBOOK, IN const BTSInterfaceType stackInterface = BTS_IF_ALPS_EVOLUTION_GENIVI);

   /**
    * Destructor.
    */
   virtual ~BtStackIfPhonebookRequest();

   virtual void registerCallback(IBtStackIfPhonebookCallback* callback);

   virtual BTSSessionHandle getSessionHandle(void) const;

   virtual BTSErrorCode init(IN const BTSLocalPhonebookConfiguration& configuration) const;

   virtual BTSErrorCode deInit(void) const;

   virtual void setPhonebookDummy(void);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const;

   virtual void setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

private:
   /**
    * Default constructor.
    */
   BtStackIfPhonebookRequest();
};

} //btstackif

#endif //_BT_STACK_IF_PHONEBOOK_REQUEST_H_
