/**
 * @file BtStackIfCallback.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Internal callback handling.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Internal callback handling.
 */

#ifndef _BT_STACK_IF_CALLBACK_H_
#define _BT_STACK_IF_CALLBACK_H_

namespace btstackif {

// class forward declarations
class IBtStackIfConfigCallback;
class IBtStackIfConnectionCallback;
class IBtStackIfTelephonyCallback;
class IBtStackIfPhonebookCallback;
class IBtStackIfMessagingCallback;
class IBtStackIfMediaPlayerCallback;
class IBtStackIfWblCallback;
class IBtStackIfEcnrCallback;

/**
 *
 */
class BtStackIfCallback
{
public:
   /**
    * Default constructor.
    */
   BtStackIfCallback();

   /**
    * Destructor.
    */
   virtual ~BtStackIfCallback();

   /**
    * Set config callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setConfigCallback(IBtStackIfConfigCallback* callback) { _configCB = callback; }

   /**
    * Get config callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfConfigCallback* getConfigCallback(void) { return _configCB; }

   /**
    * Set connection callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setConnectionCallback(IBtStackIfConnectionCallback* callback) { _connectionCB = callback; }

   /**
    * Get connection callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfConnectionCallback* getConnectionCallback(void) { return _connectionCB; }

   /**
    * Set telephony callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setTelephonyCallback(IBtStackIfTelephonyCallback* callback) { _telephonyCB = callback; }

   /**
    * Get telephony callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfTelephonyCallback* getTelephonyCallback(void) { return _telephonyCB; }

   /**
    * Set phonebook callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setPhonebookCallback(IBtStackIfPhonebookCallback* callback) { _phonebookCB = callback; }

   /**
    * Get phonebook callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfPhonebookCallback* getPhonebookCallback(void) { return _phonebookCB; }

   /**
    * Set messaging callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setMessagingCallback(IBtStackIfMessagingCallback* callback) { _messagingCB = callback; }

   /**
    * Get messaging callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfMessagingCallback* getMessagingCallback(void) { return _messagingCB; }

   /**
    * Set media player callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setMediaPlayerCallback(IBtStackIfMediaPlayerCallback* callback) { _mediaPlayerCB = callback; }

   /**
    * Get media player callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfMediaPlayerCallback* getMediaPlayerCallback(void) { return _mediaPlayerCB; }

   /**
    * Set WBL callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setWblCallback(IBtStackIfWblCallback* callback) { _wblCB = callback; }

   /**
    * Get WBL callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfWblCallback* getWblCallback(void) { return _wblCB; }

   /**
    * Set ECNR callback handler.
    *
    * @param[in] callback: callback handler
    */
   inline void setEcnrCallback(IBtStackIfEcnrCallback* callback) { _ecnrCB = callback; }

   /**
    * Get ECNR callback handler.
    *
    * @return = callback handler
    */
   inline IBtStackIfEcnrCallback* getEcnrCallback(void) { return _ecnrCB; }

private:
   IBtStackIfConfigCallback* _configCB; /**< config callback handler */
   IBtStackIfConnectionCallback* _connectionCB; /**< connection callback handler */
   IBtStackIfTelephonyCallback* _telephonyCB; /**< telephony callback handler */
   IBtStackIfPhonebookCallback* _phonebookCB; /**< phonebook callback handler */
   IBtStackIfMessagingCallback* _messagingCB; /**< messaging callback handler */
   IBtStackIfMediaPlayerCallback* _mediaPlayerCB; /**< media player callback handler */
   IBtStackIfWblCallback* _wblCB; /**< WBL callback handler */
   IBtStackIfEcnrCallback* _ecnrCB; /**< ECNR callback handler */
};

} //btstackif

#endif //_BT_STACK_IF_CALLBACK_H_
