/**
 * @file DbusWorkItem.cpp
 *
 * @par SW-Component
 * IPC
 *
 * @brief Work item for DBUS interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Work item for DBUS interface.
 */

#include "DbusWorkItem.h"
#include "IDbusTrmHandler.h"
#include "IDbusResetTrmHandler.h"
#include "IDbusCallbackHandler.h"
#include "IDbusTimeoutHandler.h"

#include <cstddef>

namespace btstackif {

DbusWorkItemTransmit::DbusWorkItemTransmit()
{
   _transmitHandler = NULL;
}

DbusWorkItemTransmit::DbusWorkItemTransmit(IDbusTrmHandler* handler)
{
   _transmitHandler = handler;
}

DbusWorkItemTransmit::~DbusWorkItemTransmit()
{
   _transmitHandler = NULL;
}

void DbusWorkItemTransmit::processWorkItem(void)
{
   if(NULL != _transmitHandler)
   {
      _transmitHandler->handleDbusTrmQueue();
   }
}

//------------------------------------------------------------------------------

DbusWorkItemResetTransmit::DbusWorkItemResetTransmit() :
_resetTransmitHandler(0)
{
}

DbusWorkItemResetTransmit::DbusWorkItemResetTransmit(IDbusResetTrmHandler* handler) :
_resetTransmitHandler(handler)
{
}

DbusWorkItemResetTransmit::~DbusWorkItemResetTransmit()
{
   _resetTransmitHandler = 0;
}

void DbusWorkItemResetTransmit::processWorkItem(void)
{
   if(0 != _resetTransmitHandler)
   {
      _resetTransmitHandler->handleDbusResetTrmQueue();
   }
}

//------------------------------------------------------------------------------

DbusWorkItemCallback::DbusWorkItemCallback()
{
   _callbackHandler = NULL;
}

DbusWorkItemCallback::DbusWorkItemCallback(IDbusCallbackHandler* handler)
{
   _callbackHandler = handler;
}

DbusWorkItemCallback::~DbusWorkItemCallback()
{
   _callbackHandler = NULL;
}

void DbusWorkItemCallback::processWorkItem(void)
{
   if(NULL != _callbackHandler)
   {
      _callbackHandler->handleDbusCallbackMessage();
   }
}

//------------------------------------------------------------------------------

DbusWorkItemTimeout::DbusWorkItemTimeout()
{
   _timeoutHandler = NULL;
}

DbusWorkItemTimeout::DbusWorkItemTimeout(IDbusTimeoutHandler* handler)
{
   _timeoutHandler = handler;
}

DbusWorkItemTimeout::~DbusWorkItemTimeout()
{
   _timeoutHandler = NULL;
}

void DbusWorkItemTimeout::processWorkItem(void)
{
   if(NULL != _timeoutHandler)
   {
      _timeoutHandler->handleDbusTimeoutEvent();
   }
}

} //btstackif
