/**
 * @file IDbusResetTrmHandler.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Interface for reset transmit handler for DBUS messages.
 *
 * @copyright (C) 2019 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for reset transmit handler for DBUS messages.
 */

#ifndef _I_DBUS_RESET_TRM_HANDLER_H_
#define _I_DBUS_RESET_TRM_HANDLER_H_

namespace btstackif {

/**
 *
 */
class IDbusResetTrmHandler
{
public:
   virtual ~IDbusResetTrmHandler() {}

   virtual void handleDbusResetTrmQueue(void) = 0;
};

} //btstackif

#endif //_I_DBUS_RESET_TRM_HANDLER_H_
