/**
 * @file IDbusRecHandler.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Interface for receive DBUS messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for receive DBUS messages.
 */

#ifndef _I_DBUS_REC_HANDLER_H_
#define _I_DBUS_REC_HANDLER_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Ipc2Bts_BaseMessage;

/**
 *
 */
class IDbusRecHandler
{
public:
   virtual ~IDbusRecHandler() {}

   virtual void handleReceivedDbusMessage(IN Ipc2Bts_BaseMessage* ptrMessage, IN const bool highPrio = false) = 0;
};

} //btstackif

#endif //_I_DBUS_REC_HANDLER_H_
