/**
 * @file DbusWorkItem.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Work item for DBUS interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Work item for DBUS interface.
 */

#ifndef _DBUS_WORK_ITEM_H_
#define _DBUS_WORK_ITEM_H_

#include "cc_dbus_if/IWorkItem.h"

namespace btstackif {

// class forward declarations
class IDbusTrmHandler;
class IDbusResetTrmHandler;
class IDbusCallbackHandler;
class IDbusTimeoutHandler;

/**
 *
 */
class DbusWorkItemTransmit : public ::ccdbusif::IWorkItem
{
public:
   DbusWorkItemTransmit();
   DbusWorkItemTransmit(IDbusTrmHandler* handler);
   virtual ~DbusWorkItemTransmit();
   virtual void processWorkItem(void);
   inline void setDbusTrmHandler(IDbusTrmHandler* handler) { _transmitHandler = handler; };

private:
   IDbusTrmHandler* _transmitHandler;
};

/**
 *
 */
class DbusWorkItemResetTransmit : public ::ccdbusif::IWorkItem
{
public:
   DbusWorkItemResetTransmit();
   DbusWorkItemResetTransmit(IDbusResetTrmHandler* handler);
   virtual ~DbusWorkItemResetTransmit();
   virtual void processWorkItem(void);
   inline void setDbusResetTrmHandler(IDbusResetTrmHandler* handler) { _resetTransmitHandler = handler; };

private:
   IDbusResetTrmHandler* _resetTransmitHandler;
};

/**
 *
 */
class DbusWorkItemCallback : public ::ccdbusif::IWorkItem
{
public:
   DbusWorkItemCallback();
   DbusWorkItemCallback(IDbusCallbackHandler* handler);
   virtual ~DbusWorkItemCallback();
   virtual void processWorkItem(void);
   inline void setDbusCallbackHandler(IDbusCallbackHandler* handler) { _callbackHandler = handler; };

private:
   IDbusCallbackHandler* _callbackHandler;
};

/**
 *
 */
class DbusWorkItemTimeout : public ::ccdbusif::IWorkItem
{
public:
   DbusWorkItemTimeout();
   DbusWorkItemTimeout(IDbusTimeoutHandler* handler);
   virtual ~DbusWorkItemTimeout();
   virtual void processWorkItem(void);
   inline void setDbusTimeutHandler(IDbusTimeoutHandler* handler) { _timeoutHandler = handler; };

private:
   IDbusTimeoutHandler* _timeoutHandler;
};

} //btstackif

#endif //_DBUS_WORK_ITEM_H_
