/**
 * @file DbusTimeoutControl.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Timeout control for DBUS messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Timeout control for DBUS messages.
 */

#ifndef _DBUS_TIMEOUT_CONTROL_H_
#define _DBUS_TIMEOUT_CONTROL_H_

#include "BtStackInternalTypes.h"
#include "ITimeoutHandler.h"

namespace btstackif {

// class forward declarations
class IDbusResponseTimeoutHandler;
class Bts2Ipc_BaseMessage;
class Timer;

/**
 * Class declaration for DBUS timeout control.
 */
class DbusTimeoutControl : public ITimeoutHandler
{
public:
   DbusTimeoutControl();
   DbusTimeoutControl(IN IDbusResponseTimeoutHandler* handler);
   DbusTimeoutControl(IN const DbusTimeoutControl& ref);
   DbusTimeoutControl& operator=(IN const DbusTimeoutControl& ref);
   bool operator==(IN const DbusTimeoutControl& ref) const;
   bool operator!=(IN const DbusTimeoutControl& ref) const;
   virtual ~DbusTimeoutControl();

   virtual void handleTimeout(IN const BTSTimerId timerId);

   inline void setHandler(IN IDbusResponseTimeoutHandler* handler) { _handler = handler; }
   inline void setMessage(IN Bts2Ipc_BaseMessage* msg) { _msg = msg; }
   inline void setTimer(IN Timer* timer) { _timer = timer; }
   inline void setInUse(IN const bool enable) { _inUse = enable; }

   inline IDbusResponseTimeoutHandler* getHandler(void) const { return _handler; }
   inline Bts2Ipc_BaseMessage* getMessage(void) const { return _msg; }
   inline Timer* getTimer(void) const { return _timer; }
   inline bool getInUse(void) const { return _inUse; }

private:
   IDbusResponseTimeoutHandler* _handler;
   Bts2Ipc_BaseMessage* _msg;
   Timer* _timer;
   bool _inUse;
};

} //btstackif

#endif //_DBUS_TIMEOUT_CONTROL_H_
