/**
 * @file TimerEntry.cpp
 *
 * @par SW-Component
 * Timer
 *
 * @brief Timer entry.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Timer entry.
 */

#include "TimerEntry.h"

namespace btstackif {

TimerEntry::TimerEntry() :
timer(0),
inUse(false)
{
}

TimerEntry::~TimerEntry()
{
   timer = 0;
}

TimerEntry::TimerEntry(const TimerEntry& ref)
{
   timer = 0;
   setTimer(ref.timer);
   inUse = ref.inUse;
}

TimerEntry& TimerEntry::operator=(const TimerEntry& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   timer = 0;
   setTimer(ref.timer);
   inUse = ref.inUse;

   return *this;
}

bool TimerEntry::operator==(const TimerEntry& ref) const
{
   bool result = true;

   result = (true == result) && (timer == ref.timer);
   result = (true == result) && (inUse == ref.inUse);

   return result;
}

bool TimerEntry::operator!=(const TimerEntry& ref) const
{
   return !(operator==(ref));
}

} //btstackif
