/**
 * @file StateMachineBase.cpp
 *
 * @par SW-Component
 * StateMachine
 *
 * @brief State machine base.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details StateMachine base class implementation.
 */

#include "StateMachineBase.h"

namespace btstackif {

StateMachineBase::StateMachineBase()
{
   _requestActive = false;
   // _app2BtsCompareItem
}

StateMachineBase::~StateMachineBase()
{
}

void StateMachineBase::reset(void)
{
   _requestActive = false;
   _app2BtsCompareItem.opCode = App2BtsOC_Last;
   _app2BtsCompareItem.deviceAddress.clear();
   _app2BtsCompareItem.protocolId = BTS_PROTO_LAST;
   _app2BtsCompareItem.sppUuid.clear();
   _app2BtsCompareItem.masInstance.clear();
   _app2BtsCompareItem.searchType = BTS_SEARCH_LAST;
}

} //btstackif
