/**
 * @file ExtendedTimer.cpp
 *
 * @par SW-Component
 * Timer
 *
 * @brief Extended timer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Extended timer.
 */

#include "ExtendedTimer.h"
#include "IBasicControl.h"
#include "FwAssert.h"

namespace btstackif {

ExtendedTimer::ExtendedTimer() :
_controlIf(0),
_handler(0),
_timer()
{
}

ExtendedTimer::~ExtendedTimer()
{
   _controlIf = 0;
   _handler = 0;
}

void ExtendedTimer::start(IN IBasicControl* control, IN IExtendedTimeoutHandler* handler, IN const BTSTimeValue timeout)
{
   _controlIf = control;
   FW_IF_NULL_PTR_RETURN(_controlIf);

   _handler = handler;
   FW_IF_NULL_PTR_RETURN(_handler);

   _timer.start(timeout, this);
}

void ExtendedTimer::stop(void)
{
   _timer.stop();
}

bool ExtendedTimer::isActive(void) const
{
   return _timer.isActive();
}

BTSTimerId ExtendedTimer::getTimerId(void) const
{
   return _timer.getTimerId();
}

void ExtendedTimer::handleTimeout(IN const BTSTimerId timerId)
{
   FW_IF_NULL_PTR_RETURN(_controlIf);
   FW_IF_NULL_PTR_RETURN(_handler);

   _controlIf->handleTimeout(_handler, timerId);
}

} //btstackif
