/**
 * @file BtStackInternalTypesTrace.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace enum to string.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace enum to string.
 * This file is completely generated by parser tooling (code generation). => DO NOT EDIT!
 */

#include "BtStackInternalTypesTrace.h"

namespace btstackif {

const char* getFactoryCreator2String(BTSFactoryCreator value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_LOCAL_CREATE:
         result = "LOCAL_CREATE";
         break;
      case BTS_EXTERN_CREATE:
         result = "EXTERN_CREATE";
         break;
      default:
         break;
   }

   return result;
}

const char* getMessageType2String(BTSMessageType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_APP_TO_BTS:
         result = "APP_TO_BTS";
         break;
      case BTS_BTS_TO_APP:
         result = "BTS_TO_APP";
         break;
      case BTS_BTS_TO_IPC:
         result = "BTS_TO_IPC";
         break;
      case BTS_IPC_TO_BTS:
         result = "IPC_TO_BTS";
         break;
      case BTS_X_TO_Y_LAST:
         result = "X_TO_Y_LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getIpcCommonErrorCode2String(BTSIpcCommonErrorCode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_IPC_SUCCESS:
         result = "SUCCESS";
         break;
      case BTS_IPC_METHOD_RETURN_TIMEOUT:
         result = "METHOD_RETURN_TIMEOUT";
         break;
      case BTS_IPC_SENDING_FAILED:
         result = "SENDING_FAILED";
         break;
      case BTS_IPC_ERROR:
         result = "ERROR";
         break;
      case BTS_IPC_UPDATE_TIMEOUT:
         result = "UPDATE_TIMEOUT";
         break;
      case BTS_IPC_BUSY:
         result = "BUSY";
         break;
      case BTS_IPC_RETRY_ABORTED:
         result = "RETRY_ABORTED";
         break;
      case BTS_IPC_ALREADY_CONNECTED:
         result = "ALREADY_CONNECTED";
         break;
      case BTS_IPC_NOT_CONNECTED:
         result = "NOT_CONNECTED";
         break;
      case BTS_IPC_ALREADY_CREATED:
         result = "ALREADY_CREATED";
         break;
      case BTS_IPC_PAIRING_CONN_LOST:
         result = "PAIRING_CONN_LOST";
         break;
      case BTS_IPC_PAIRING_AUTHENTICATION_ERROR:
         result = "PAIRING_AUTHENTICATION_ERROR";
         break;
      case BTS_IPC_PAIRING_PAIRING_CANCELLED:
         result = "PAIRING_PAIRING_CANCELLED";
         break;
      case BTS_IPC_PAIRING_MISSING_PIN:
         result = "PAIRING_MISSING_PIN";
         break;
      case BTS_IPC_PAIRING_UNKNOWN:
         result = "PAIRING_UNKNOWN";
         break;
      case BTS_IPC_DBUS_ERROR_NO_SERVER:
         result = "DBUS_ERROR_NO_SERVER";
         break;
      case BTS_IPC_CANCELLED:
         result = "CANCELLED";
         break;
      case BTS_IPC_CONNECTION_CONFLICT_SAME_DEVICE:
         result = "CONNECTION_CONFLICT_SAME_DEVICE";
         break;
      case BTS_IPC_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getSemaphoreSection2String(BTSSemaphoreSection value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SEM_COMMON:
         result = "COMMON";
         break;
      case BTS_SEM_CONNECTION:
         result = "CONNECTION";
         break;
      case BTS_SEM_PHONECALL:
         result = "PHONECALL";
         break;
      case BTS_SEM_PHONEBOOK:
         result = "PHONEBOOK";
         break;
      case BTS_SEM_MESSAGING:
         result = "MESSAGING";
         break;
      case BTS_SEM_MEDIA_PLAYER:
         result = "MEDIA_PLAYER";
         break;
      case BTS_SEM_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDbusServiceAvailability2String(BTSDbusServiceAvailability value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DBUS_SERVICE_NOT_AVAILABLE:
         result = "NOT_AVAILABLE";
         break;
      case BTS_DBUS_SERVICE_WAITING:
         result = "WAITING";
         break;
      case BTS_DBUS_SERVICE_AVAILABLE:
         result = "AVAILABLE";
         break;
      case BTS_DBUS_SERVICE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getTestCommandGroup2String(BTSTestCommandGroup value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_TEST_COMMAND_GROUP_GENERIC:
         result = "GENERIC";
         break;
      case BTS_TEST_COMMAND_GROUP_MAIN:
         result = "MAIN";
         break;
      case BTS_TEST_COMMAND_GROUP_CONNECTION:
         result = "CONNECTION";
         break;
      case BTS_TEST_COMMAND_GROUP_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBtRole2String(BTSBtRole value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_MASTER:
         result = "MASTER";
         break;
      case BTS_BT_SLAVE:
         result = "SLAVE";
         break;
      case BTS_BT_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getInternalDisconnectReason2String(BTSInternalDisconnectReason value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_INT_DISCONNECT_REASON_LOCAL_DEVICE:
         result = "LOCAL_DEVICE";
         break;
      case BTS_INT_DISCONNECT_REASON_REMOTE_DEVICE:
         result = "REMOTE_DEVICE";
         break;
      case BTS_INT_DISCONNECT_REASON_EXCEPTION:
         result = "EXCEPTION";
         break;
      case BTS_INT_DISCONNECT_REASON_LINK_LOSS:
         result = "LINK_LOSS";
         break;
      case BTS_INT_DISCONNECT_REASON_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getStatusTransition2String(BTSStatusTransition value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_STATUS_TRANSITION_NO_CHANGE:
         result = "NO_CHANGE";
         break;
      case BTS_STATUS_TRANSITION_ENABLED:
         result = "ENABLED";
         break;
      case BTS_STATUS_TRANSITION_DISABLED:
         result = "DISABLED";
         break;
      case BTS_STATUS_TRANSITION_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getGeniviTraceLevelBit2String(BTSGeniviTraceLevelBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_GENIVI_TRACE_LEVEL_FATAL:
         result = "FATAL";
         break;
      case BTS_GENIVI_TRACE_LEVEL_ERROR:
         result = "ERROR";
         break;
      case BTS_GENIVI_TRACE_LEVEL_WARNING:
         result = "WARNING";
         break;
      case BTS_GENIVI_TRACE_LEVEL_INFO:
         result = "INFO";
         break;
      case BTS_GENIVI_TRACE_LEVEL_DEBUG:
         result = "DEBUG";
         break;
      case BTS_GENIVI_TRACE_LEVEL_LOG:
         result = "LOG";
         break;
      case BTS_GENIVI_TRACE_LEVEL_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getGeniviTraceCategoryBit2String(BTSGeniviTraceCategoryBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_GENIVI_TRACE_CATEGORY_OFD_INTROSPECTABLE:
         result = "OFD_INTROSPECTABLE";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_OFD_PROPERTIES:
         result = "OFD_PROPERTIES";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_OFD_OBJECT_MANAGER:
         result = "OFD_OBJECT_MANAGER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_ADAPTER:
         result = "ADAPTER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_AGENT:
         result = "AGENT";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_AGENT_MANAGER:
         result = "AGENT_MANAGER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_DEVICE:
         result = "DEVICE";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_SERVICE:
         result = "SERVICE";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_TRACE:
         result = "TRACE";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_DM:
         result = "DM";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_HANDSFREE:
         result = "HANDSFREE";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MANAGER:
         result = "MANAGER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MODEM:
         result = "MODEM";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_VOICE_CALL:
         result = "VOICE_CALL";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_VOICE_CALL_MANAGER:
         result = "VOICE_CALL_MANAGER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_NETWORK_REGISTRATION:
         result = "NETWORK_REGISTRATION";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_NETWORK_OPERATOR:
         result = "NETWORK_OPERATOR";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_CALL_VOLUME:
         result = "CALL_VOLUME";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_SIRI:
         result = "SIRI";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_CLIENT:
         result = "CLIENT";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_PHONEBOOK_ACCESS:
         result = "PHONEBOOK_ACCESS";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_SESSION:
         result = "SESSION";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_TRANSFER:
         result = "TRANSFER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_AVP:
         result = "AVP";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MEDIA_FOLDER:
         result = "MEDIA_FOLDER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MEDIA_ITEM:
         result = "MEDIA_ITEM";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MEDIA_PLAYER:
         result = "MEDIA_PLAYER";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MEDIA_TRANSPORT:
         result = "MEDIA_TRANSPORT";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MESSAGE:
         result = "MESSAGE";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_MESSAGE_ACCESS:
         result = "MESSAGE_ACCESS";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_CTN:
         result = "CTN";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_OPPC:
         result = "OPPC";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_OPPS:
         result = "OPPS";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_SPP:
         result = "SPP";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_DID:
         result = "DID";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_DUN:
         result = "DUN";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_PAN:
         result = "PAN";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_NETWORK:
         result = "NETWORK";
         break;
      case BTS_GENIVI_TRACE_CATEGORY_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBtPowerMode2String(BTSBtPowerMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_POWER_MODE_ACTIVE:
         result = "ACTIVE";
         break;
      case BTS_BT_POWER_MODE_HOLD:
         result = "HOLD";
         break;
      case BTS_BT_POWER_MODE_SNIFF:
         result = "SNIFF";
         break;
      case BTS_BT_POWER_MODE_PARK:
         result = "PARK";
         break;
      case BTS_BT_POWER_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getConfigurationParameter2String(BTSConfigurationParameter value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_CONFIG_PARAM_LOCAL_SERVICES:
         result = "LOCAL_SERVICES";
         break;
      case BTS_CONFIG_PARAM_PAGE_TIMEOUT:
         result = "PAGE_TIMEOUT";
         break;
      case BTS_CONFIG_PARAM_PAGE_TIMEOUT_SECOND:
         result = "PAGE_TIMEOUT_SECOND";
         break;
      case BTS_CONFIG_PARAM_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getApp2BtsMessageHandlingType2String(BTSApp2BtsMessageHandlingType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_APP2BTS_PUSH_TO_WORKING:
         result = "PUSH_TO_WORKING";
         break;
      case BTS_APP2BTS_PUSH_TO_WAITING:
         result = "PUSH_TO_WAITING";
         break;
      case BTS_APP2BTS_DELETE:
         result = "DELETE";
         break;
      case BTS_APP2BTS_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getHandsfreeAgFeaturesBit2String(BTSHandsfreeAgFeaturesBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_HFP_AG_FEATURE_VOICE_RECOGNITION:
         result = "VOICE_RECOGNITION";
         break;
      case BTS_HFP_AG_FEATURE_ATTACH_VOICE_TAG:
         result = "ATTACH_VOICE_TAG";
         break;
      case BTS_HFP_AG_FEATURE_3WAY:
         result = "3WAY";
         break;
      case BTS_HFP_AG_FEATURE_ECNR:
         result = "ECNR";
         break;
      case BTS_HFP_AG_FEATURE_INBAND_RING:
         result = "INBAND_RING";
         break;
      case BTS_HFP_AG_FEATURE_REJECT_INCOMING_CALL:
         result = "REJECT_INCOMING_CALL";
         break;
      case BTS_HFP_AG_FEATURE_ENHANCED_CALL_STATUS:
         result = "ENHANCED_CALL_STATUS";
         break;
      case BTS_HFP_AG_FEATURE_ENHANCED_CALL_CONTROL:
         result = "ENHANCED_CALL_CONTROL";
         break;
      case BTS_HFP_AG_FEATURE_EXTENDED_ERROR_CODES:
         result = "EXTENDED_ERROR_CODES";
         break;
      case BTS_HFP_AG_FEATURE_CODEC_NEGOTIATION:
         result = "CODEC_NEGOTIATION";
         break;
      case BTS_HFP_AG_FEATURE_HF_INDICATORS:
         result = "HF_INDICATORS";
         break;
      case BTS_HFP_AG_FEATURE_ESCO_S4_AND_T2_SETTING_SUPPORTED:
         result = "ESCO_S4_AND_T2_SETTING_SUPPORTED";
         break;
      case BTS_HFP_AG_FEATURE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

} //btstackif
