/**
 * @file TimerEntry.h
 *
 * @par SW-Component
 * Timer
 *
 * @brief Timer entry.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Timer entry.
 */

#ifndef _TIMER_ENTRY_H_
#define _TIMER_ENTRY_H_

namespace btstackif {

// class forward declarations
class Timer;

/**
 *
 */
class TimerEntry
{
public:
   TimerEntry();

   virtual ~TimerEntry();

   TimerEntry(const TimerEntry& ref);

   TimerEntry& operator=(const TimerEntry& ref);

   bool operator==(const TimerEntry& ref) const;

   bool operator!=(const TimerEntry& ref) const;

   // member with public access
   Timer* timer; /**< timer */
   bool inUse; /**< in use flag */

private:
   inline void setTimer(Timer* ptrTimer) { timer = ptrTimer; }
};

} //btstackif

#endif //_TIMER_ENTRY_H_
