/**
 * @file ServiceAvailabilityHandler.h
 *
 * @par SW-Component
 * Common
 *
 * @brief Service Availability Handler.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of service availability handler.
 */

#ifndef _SERVICE_AVAILABILITY_HANDLER_H_
#define _SERVICE_AVAILABILITY_HANDLER_H_

#include "BtStackInternalTypes.h"
#include "IServiceAvailabilityHandler.h"
#include "TimeoutSemaphore.h"

namespace btstackif {

/**
 *
 */
class ServiceAvailabilityHandler : public IServiceAvailabilityHandler
{
public:
   ServiceAvailabilityHandler();
   virtual ~ServiceAvailabilityHandler();
   inline void setServiceName(IN const char* name) { if(NULL != name) { _serviceName = name; } }
   inline void setServiceAvailable(IN const bool enable) { _serviceAvailable = enable; }
   inline bool getServiceAvailable(void) const { return _serviceAvailable; }
   void reset(void);
   bool waitForServiceAvailable(void);
   virtual void handleServiceAvailability(IN const bool available);

private:
   enum
   {
      SERVICE_WAITING_TIMEOUT_MS = 5000
   };

   ::std::string _serviceName;
   bool _serviceAvailable;
   TimeoutSemaphore _semaphore;
};

} //btstackif

#endif //_SERVICE_AVAILABILITY_HANDLER_H_
