/**
 * @file ITimerPool.h
 *
 * @par SW-Component
 * Timer
 *
 * @brief Interface definition for timer pool.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for timer pool.
 */

#ifndef _I_TIMER_POOL_H_
#define _I_TIMER_POOL_H_

namespace btstackif {

// class forward declarations
class Timer;
class IExtendedTimer;

/**
 * Interface definition.
 */
class ITimerPool
{
public:
   /**
    * Destructor.
    */
   virtual ~ITimerPool() {}

   /**
    * Create timer pool.
    */
   virtual void create(void) = 0;

   /**
    * Destroy timer pool.
    */
   virtual void destroy(void) = 0;

   /**
    * Get timer.
    *
    * @return = timer
    */
   virtual Timer* getTimer(void) = 0;

   /**
    * Release timer.
    *
    * @param[in] timer: timer
    */
   virtual void releaseTimer(Timer* timer) = 0;

   /**
    * Get extended timer.
    *
    * @return = extended timer
    */
   virtual IExtendedTimer* getExtendedTimer(void) = 0;

   /**
    * Release extended timer.
    *
    * @param[in] timer: extended timer
    */
   virtual void releaseExtendedTimer(IExtendedTimer* timer) = 0;

   /**
    * Get number of timers.
    *
    * @param[in] nmbTimer: number of timer
    * @param[in] nmbUsedTimer: number of used timer
    * @param[in] nmbExtendedTimer: number of extended timer
    * @param[in] nmbUsedExtendedTimer: number of used extended timer
    */
   virtual void getTimerCount(unsigned int& nmbTimer, unsigned int& nmbUsedTimer, unsigned int& nmbExtendedTimer, unsigned int& nmbUsedExtendedTimer) = 0;
};

} //btstackif

#endif //_I_TIMER_POOL_H_
