/**
 * @file IServiceAvailabilityHandler.h
 *
 * @par SW-Component
 * Common
 *
 * @brief Service Availability Handler Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for Service Availability Handler.
 */

#ifndef _I_SERVICE_AVAILABILITY_HANDLER_H_
#define _I_SERVICE_AVAILABILITY_HANDLER_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

/**
 *
 */
class IServiceAvailabilityHandler
{
public:
   virtual ~IServiceAvailabilityHandler() {}

   virtual void handleServiceAvailability(IN const bool available) = 0;
};

} //btstackif

#endif //_I_SERVICE_AVAILABILITY_HANDLER_H_
