/**
 * @file IExtendedTimer.h
 *
 * @par SW-Component
 * Timer
 *
 * @brief Extended timer interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Extended timer interface.
 */

#ifndef _I_EXTENDED_TIMER_H_
#define _I_EXTENDED_TIMER_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IBasicControl;
class IExtendedTimeoutHandler;

/**
 * Extended timer interface.
 */
class IExtendedTimer
{
public:
   /**
    * Destructor.
    */
   virtual ~IExtendedTimer() {}

   /**
    * Start timer.
    *
    * @param[in] control: basic control interface
    * @param[in] handler: extended timeout handler
    * @param[in] timeout: timeout value
    */
   virtual void start(IN IBasicControl* control, IN IExtendedTimeoutHandler* handler, IN const BTSTimeValue timeout) = 0;

   /**
    * Stop timer.
    */
   virtual void stop(void) = 0;

   /**
    * Check if timer is active.
    *
    * @return = true: timer is active,
    * @return = false: timer is inactive
    */
   virtual bool isActive(void) const = 0;

   /**
    * Get timer id.
    *
    * @return = timer id
    */
   virtual BTSTimerId getTimerId(void) const = 0;
};

} //btstackif

#endif //_I_EXTENDED_TIMER_H_
