/**
 * @file BtsUtils.h
 *
 * @par SW-Component
 * Utilities
 *
 * @brief Utilities.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Utilities.
 */

#ifndef _BTS_UTILS_H_
#define _BTS_UTILS_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

void convertBinary2HexStringValue(OUT ::std::string& stringValue, IN const ::std::vector< unsigned char >& binaryValue, IN const ::std::string& example, IN const bool allowEmpty = false);
void convertHexString2BinaryValue(OUT ::std::vector< unsigned char >& binaryValue, IN const ::std::string& stringValue, IN const ::std::string& example, IN const bool allowEmpty = false);
void convertBdAddressString2Binary(OUT BTSBinaryBDAddress& binaryDeviceAddress, IN const BTSBDAddress& stringDeviceAddress, IN const bool allowEmpty = false);
void convertBdAddressBinary2String(OUT BTSBDAddress& stringDeviceAddress, IN const BTSBinaryBDAddress& binaryDeviceAddress);
void convertBdAddressBinary2String(OUT BTSBDAddress& stringDeviceAddress, IN const ::std::vector< unsigned char >& binaryDeviceAddress);
unsigned char convertHexString2Binary(IN const char* hexString);
void convertBinary2HexString(OUT char* hexString, IN const unsigned char binaryVal);
bool isValidBdAddress(IN const BTSBDAddress& address, IN const bool allowEmpty = true);
bool isValidLinkKey(IN const BTSLinkKey& linkKey);
bool isValidPinCode(IN const BTSPinCode& pinCode);
bool isValidNumericValue(IN const BTSNumericValue& numericValue);
bool isValidUuid(IN const BTSUuid& uuid);
bool isValidDLinkKey(IN const BTSDLinkKey& dLinkKey);
bool isValidUserId(IN const BTSUserId& userId);
void convertNumericValueBinary2String(OUT BTSNumericValue& stringNumericValue, IN const unsigned int binaryNumericValue);
void convertNumericValueString2Binary(OUT unsigned int& binaryNumericValue, IN const BTSNumericValue& stringNumericValue);
void convertLinkKeyBinary2String(OUT BTSLinkKey& stringLinkKey, IN const ::std::vector< unsigned char >& binaryLinkKey, IN const bool allowEmpty = false);
void convertDLinkKeyBinary2String(OUT BTSDLinkKey& stringDLinkKey, IN const ::std::vector< unsigned char >& binaryDLinkKey, IN const bool allowEmpty = false);
void convertLinkKeyString2Binary(OUT ::std::vector< unsigned char >& binaryLinkKey, IN const BTSLinkKey& stringLinkKey, IN const bool allowEmpty = false);
void convertDLinkKeyString2Binary(OUT ::std::vector< unsigned char >& binaryDLinkKey, IN const BTSDLinkKey& stringDLinkKey, IN const bool allowEmpty = false);
void convertUuidBinary2String(OUT BTSUuid& stringUuid, IN const ::std::vector< unsigned char >& binaryUuid);
void convertUuidString2Binary(OUT ::std::vector< unsigned char >& binaryUuid, IN const BTSUuid& stringUuid);
void listCharacterDevices(IN const ::std::string& filter);
BTSDisconnectReason convertInternalDisconnectReason2Public(IN const BTSInternalDisconnectReason internalReason);
BTSProtocolId convertSupportedService2Protocol(IN const BTSSupportedServicesBit supportedServicesBit);

/**
 * Calculates message trace id.
 *
 * @param[in] component: component
 * @param[in] stackInterface: stack interface to be used (Bluetooth stack)
 * @param[in] opCode: message opcode
 *
 * @return = message trace id
 */
uint32_t calcMessageTraceId(IN const uint32_t component, IN const uint32_t stackInterface, IN const uint32_t opCode);

/**
 * Extracts sub component id from opcode.
 *
 * @param[in] opCode: message opcode
 *
 * @return = sub component id
 */
BTSFunctionBlock extractSubComponentFromBts2AppOpCode(IN const BTSBts2AppOpcode opCode);

/**
 * Extracts sub component id from opcode.
 *
 * @param[in] opCode: message opcode
 *
 * @return = sub component id
 */
BTSFunctionBlock extractSubComponentFromApp2BtsOpCode(IN const BTSApp2BtsOpcode opCode);

} //btstackif

#endif //_BTS_UTILS_H_
