/**
 * @file BtsSmfWrapper.h
 *
 * @par SW-Component
 * StateMachine
 *
 * @brief StateMachine wrapper.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration for StateMachine wrapper.
 */

#ifndef _BTS_SMF_WRAPPER_H_
#define _BTS_SMF_WRAPPER_H_

#include "BtStackInternalTypes.h"
#include "FwSmf.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;
class BtStackIfCallback;

/**
 *
 */
class SmfWrapper : public SMF
{
public:
   /**
    * Default constructor.
    */
   SmfWrapper();

   /**
    * Destructor.
    */
   virtual ~SmfWrapper();

   /**
    * Reset SM.
    */
   void resetSm(void);

   /**
    * Do state machine processing.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] ptrUser: user reference
    * @param[in] sessionHandle: session handle
    *
    * @return = true: SM finished,
    * @return = false: SM not finished
    */
   bool doSmProcessing(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN BtStackIfCallback* callback = NULL, IN const BTSSessionHandle sessionHandle = 0);

protected:
   bool _createDone; /**< flag indicating SM creation */
   ::std::vector< Bts2Ipc_BaseMessage* > _bts2IpcList; /**< internal list with BTS2IPC messages */
   ::std::vector< Bts2App_BaseMessage* > _bts2AppResultList; /**< internal list with BTS2APP result messages */
   ::std::vector< Bts2App_BaseMessage* > _bts2AppStatusList; /**< internal list with BTS2APP status messages */
   BTSHandleIpc2BtsMessageItem _messageItem; /**< message item */

   /**
    * Create SM.
    */
   void createSm(void);

   /**
    * Reset data within SMF wrapper.
    */
   void resetSmfWrapperData(void);

   /**
    * Add Bts2Ipc message to internal list.
    *
    * @param[in] message: Bts2Ipc message
    */
   void addBts2IpcMsg(IN Bts2Ipc_BaseMessage* message);

   /**
    * Add Bts2App message to internal list.
    *
    * @param[in] message: Bts2App message
    * @param[in] isResultMsg: flag indicating if this message is a result or a status message
    */
   void addBts2AppMsg(IN Bts2App_BaseMessage* message, IN const bool isResultMsg);
};

} //btstackif

#endif //_BTS_SMF_WRAPPER_H_
