/**
 * @file BtStackInternalSmTypes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief Basic types for StateMachines (common for all).
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all internal types for StateMachines (common for all).
 * HINT: This header file shall only be included in specific XxxStackSmTypes.h.
 */

#ifndef _BT_STACK_INTERNAL_SM_TYPES_H_
#define _BT_STACK_INTERNAL_SM_TYPES_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

#define BTS_BDADDRESS_STRING_SIZE 13 /**< size of BD address as string (including NULL termination) */
#define BTSBDADDRESSCHRARR_FORMAT "t" /**< format of BD address */
#define BTSBDADDRESSCHRARR_INIT "" /**< init value of BD address */

#define BTS_BDUUID_STRING_SIZE 33 /**< size of BD uuid as string (including NULL termination) */
#define BTSUUIDCHRARR_FORMAT "t" /**< format of BD uuid */
#define BTSUUIDCHRARR_INIT "" /**< init value of BD uuid */

#define BTS_BDDEVICE_NAME_STRING_SIZE 129 /**< size of BD remote device name as string (including NULL termination) */
#define BTSDEVICENAMECHRARR_FORMAT "t" /**< format of BD remote device name */
#define BTSDEVICENAMECHRARR_INIT "" /**< init value of BD remote device name */

/**
 * Type definition for Bluetooth device address with fixed size (hexadecimal characters without colons).
 */
typedef char BTSBdAddressChrArr[BTS_BDADDRESS_STRING_SIZE];

/**
 * Type definition for Bluetooth device uuid with fixed size (hexadecimal characters without colons).
 */
typedef char BTSUuidChrArr[BTS_BDUUID_STRING_SIZE];

/**
 * Type definition for Bluetooth device name with fixed size (hexadecimal characters without colons).
 */
typedef char BTSDeviceNameChrArr[BTS_BDDEVICE_NAME_STRING_SIZE];

//------------------------------------------------------------------------------

#define BTSREQUESTRESULT_FORMAT "i" /**< format of BTSRequestResult */
#define BTSREQUESTRESULT_INIT BTS_REQ_LAST /**< init value of BTSRequestResult */

//------------------------------------------------------------------------------

#define BTSPROTOCOLID_FORMAT "i" /**< format of BTSProtocolId */
#define BTSPROTOCOLID_INIT BTS_PROTO_LAST /**< init value of BTSProtocolId */

//------------------------------------------------------------------------------

#define BTSCONNECTIONSTATUS_FORMAT "i" /**< format of BTSConnectionStatus */
#define BTSCONNECTIONSTATUS_INIT BTS_CONN_LAST /**< init value of BTSConnectionStatus */

//------------------------------------------------------------------------------

#define BTSDISCONNECTREASON_FORMAT "i" /**< format of BTSDisconnectReason */
#define BTSDISCONNECTREASON_INIT BTS_DISCONNECT_REASON_LAST /**< init value of BTSDisconnectReason */

//------------------------------------------------------------------------------

#define INT_FORMAT "i" /**< format of bool */
#define INT_INIT 0 /**< init value of bool */

//------------------------------------------------------------------------------

} //btstackif

#endif //_BT_STACK_INTERNAL_SM_TYPES_H_
