/**
 * @file BtStackInternalOpcodes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief Internal opcodes.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of internal opcodes.
 */

#ifndef _BT_STACK_INTERNAL_OPCODES_H_
#define _BT_STACK_INTERNAL_OPCODES_H_

#include "BtStackIfTypes.h"

namespace btstackif {

/**
 * Type definition for opcodes of messages from application to BtStackIf.
 */
enum BTSApp2BtsOpcode
{
   App2BtsOC_None = 0, /**< none */
   App2BtsOC_Ignore, /**< ignore */

   // configuration block
   App2BtsOC_ConfigurationBlockStart = (BTS_FB_CONFIG << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetDummy,
   // -------------------------------------------------------------------------
   App2BtsOC_ConfigurationBlockEnd,

   // connection management block
   App2BtsOC_ConnectionBlockStart = (BTS_FB_CONNECTION << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_StartInternalCommunication,
   App2BtsOC_TriggerFbConnectionInitialized,
   App2BtsOC_SwitchBluetoothOnOff,
   App2BtsOC_GetBluetoothOnOffStatus,
   App2BtsOC_SwitchBluetoothHardwareOnOff,
   App2BtsOC_SetLocalBtName,
   App2BtsOC_GetLocalBtName,
   App2BtsOC_SetDeviceIdServiceRecord,
   App2BtsOC_SetDeviceForRestrictedPairingConnecting,
   App2BtsOC_SetLocalAdapterModes,
   App2BtsOC_GetLocalAdapterModes,
   App2BtsOC_StartDiscovery,
   App2BtsOC_StopDiscovery,
   App2BtsOC_GetDiscoveringStatus,
   App2BtsOC_StartPairing,
   App2BtsOC_CancelPairing,
   App2BtsOC_SetPinCode,
   App2BtsOC_ConfirmSecureSimplePairing,
   App2BtsOC_SetLinkKey,
   App2BtsOC_ConnectProtocol,
   App2BtsOC_AcceptRemoteProtocolConnect,
   App2BtsOC_RejectRemoteProtocolConnect,
   App2BtsOC_DisconnectProtocol,
   App2BtsOC_DisconnectDevice,
   App2BtsOC_GetProtocolConnectionStatus,
   App2BtsOC_GetDeviceConnectionStatus,
   App2BtsOC_StartRemoteServiceSearch,
   App2BtsOC_CancelRemoteServiceSearch,
   App2BtsOC_QueryRemoteName,
   App2BtsOC_RequestLinkQuality,
   App2BtsOC_StartTestMode,
   App2BtsOC_StopTestMode,
   App2BtsOC_RequestTestModeLinkQuality,
   // -------------------------------------------------------------------------
   App2BtsOC_ConnectionBlockEnd,

   // phonecall block
   App2BtsOC_TelephonyBlockStart = (BTS_FB_TELEPHONY << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetTelephonyDummy,
   // -------------------------------------------------------------------------
   App2BtsOC_TelephonyBlockEnd,

   // phonebook block
   App2BtsOC_PhonebookBlockStart = (BTS_FB_PHONEBOOK << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetPhonebookDummy,
   // -------------------------------------------------------------------------
   App2BtsOC_PhonebookBlockEnd,

   // messaging block
   App2BtsOC_MessagingBlockStart = (BTS_FB_MESSAGING << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetMessagingDummy,
   // -------------------------------------------------------------------------
   App2BtsOC_MessagingBlockEnd,

   // media player block
   App2BtsOC_MediaPlayerBlockStart = (BTS_FB_MEDIAPLAYER << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetMediaPlayerDummy,
   // -------------------------------------------------------------------------
   App2BtsOC_MediaPlayerBlockEnd,

   // WBL block
   App2BtsOC_WblBlockStart = (BTS_FB_WBL << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetWblDummy,
   App2BtsOC_TriggerFbWblInitialized,
   App2BtsOC_AllowWblCommunication,
   App2BtsOC_BlockWblCommunication,
   App2BtsOC_GetWblCommunicationStatus,
   App2BtsOC_GetWblServiceAvailability,
   App2BtsOC_GetWblLastIntendedMode,
   App2BtsOC_GetWblSupportedRestrictions,
   App2BtsOC_GetWblWiFiSetupStatus,
   App2BtsOC_GetWblHealthinessIndicator,
   // -------------------------------------------------------------------------
   App2BtsOC_WblBlockEnd,

   // ECNR block
   App2BtsOC_EcnrBlockStart = (BTS_FB_ECNR << 12),
   // -------------------------------------------------------------------------
   App2BtsOC_SetEcnrDummy,
   // -------------------------------------------------------------------------
   App2BtsOC_EcnrBlockEnd,

   // -------------------------------------------------------------------------
   App2BtsOC_Last /**< end marker, must be the last one */
};

/**
 * Type definition for opcodes of messages from BtStackIf to application.
 */
enum BTSBts2AppOpcode
{
   Bts2AppOC_None = 0, /**< none */

   // configuration block
   Bts2AppOC_ConfigurationBlockStart = (1 << 11) | (BTS_FB_CONFIG << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_SetDummyResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_ConfigurationBlockEnd,

   // connection management block
   Bts2AppOC_ConnectionBlockStart = (1 << 11) | (BTS_FB_CONNECTION << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbConnectionInitialized,
   Bts2AppOC_LocalVersionInfo,
   Bts2AppOC_SwitchBluetoothOnOffResult,
   Bts2AppOC_CurrentBluetoothOnOffStatus,
   Bts2AppOC_SwitchBluetoothHardwareOnOffResult,
   Bts2AppOC_SetLocalBtNameResult,
   Bts2AppOC_CurrentLocalBtName,
   Bts2AppOC_CurrentDeviceForRestrictedPairingConnecting,
   Bts2AppOC_SetLocalAdapterModesResult,
   Bts2AppOC_CurrentDiscoverableMode,
   Bts2AppOC_CurrentConnectableMode,
   Bts2AppOC_StartDiscoveryResult,
   Bts2AppOC_StopDiscoveryResult,
   Bts2AppOC_DiscoveringStatus,
   Bts2AppOC_DiscoveredDeviceFound,
   Bts2AppOC_StartPairingResult,
   Bts2AppOC_PinCodeRequested,
   Bts2AppOC_SecureSimplePairingRequested,
   Bts2AppOC_PairingFinished,
   Bts2AppOC_LinkKeyRequested,
   Bts2AppOC_ConnectProtocolResult,
   Bts2AppOC_RemoteProtocolConnectRequest,
   Bts2AppOC_DisconnectProtocolResult,
   Bts2AppOC_DisconnectDeviceResult,
   Bts2AppOC_ProtocolConnectionStatus,
   Bts2AppOC_DeviceConnectionStatus,
   Bts2AppOC_DeviceCapabilities,
   Bts2AppOC_RemoteSupportedServices,
   Bts2AppOC_RemoteSppCapabilities,
   Bts2AppOC_RemoteDeviceIdServiceRecords,
   Bts2AppOC_RemoteServiceSearchResult,
   Bts2AppOC_RemoteNameResult,
   Bts2AppOC_RemoteNameStatus,
   Bts2AppOC_LinkQualityResult,
   Bts2AppOC_StartTestModeResult,
   Bts2AppOC_StopTestModeResult,
   Bts2AppOC_TestModeStatus,
   Bts2AppOC_TestModeLinkQualityResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_ConnectionBlockEnd,

   // phonecall block
   Bts2AppOC_TelephonyBlockStart = (1 << 11) | (BTS_FB_TELEPHONY << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbTelephonyInitialized,
   Bts2AppOC_SetTelephonyDummyResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_TelephonyBlockEnd,

   // phonebook block
   Bts2AppOC_PhonebookBlockStart = (1 << 11) | (BTS_FB_PHONEBOOK << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbPhonebookInitialized,
   Bts2AppOC_SetPhonebookDummyResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_PhonebookBlockEnd,

   // messaging block
   Bts2AppOC_MessagingBlockStart = (1 << 11) | (BTS_FB_MESSAGING << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbMessagingInitialized,
   Bts2AppOC_SetMessagingDummyResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_MessagingBlockEnd,

   // media player block
   Bts2AppOC_MediaPlayerBlockStart = (1 << 11) | (BTS_FB_MEDIAPLAYER << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbMediaPlayerInitialized,
   Bts2AppOC_SetMediaPlayerDummyResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_MediaPlayerBlockEnd,

   // WBL block
   Bts2AppOC_WblBlockStart = (1 << 11) | (BTS_FB_WBL << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbWblInitialized,
   Bts2AppOC_SetWblDummyResult,
   Bts2AppOC_AllowWblCommunicationResult,
   Bts2AppOC_BlockWblCommunicationResult,
   Bts2AppOC_WblCommunicationStatus,
   Bts2AppOC_WblServiceAvailability,
   Bts2AppOC_WblLastIntendedMode,
   Bts2AppOC_WblSupportedRestrictions,
   Bts2AppOC_WblWiFiSetupStatus,
   Bts2AppOC_WblHealthinessIndicator,
   // -------------------------------------------------------------------------
   Bts2AppOC_WblBlockEnd,

   // ECNR block
   Bts2AppOC_EcnrBlockStart = (1 << 11) | (BTS_FB_ECNR << 12),
   // -------------------------------------------------------------------------
   Bts2AppOC_FbEcnrInitialized,
   Bts2AppOC_SetEcnrDummyResult,
   // -------------------------------------------------------------------------
   Bts2AppOC_EcnrBlockEnd,

   // -------------------------------------------------------------------------
   Bts2AppOC_Last /**< end marker, must be the last one */
};

} //btstackif

#endif //_BT_STACK_INTERNAL_OPCODES_H_
