/**
 * @file Bts2Ipc_BaseMessage.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of base message for BtStackIf to IPC messages.
 */

#include "Bts2Ipc_BaseMessage.h"
#include "BtsUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
#include "FwMemoryChecker.h"
#endif

namespace btstackif {

unsigned int Bts2Ipc_BaseMessage::_countBts2IpcMessages = 0;

Bts2Ipc_BaseMessage::Bts2Ipc_BaseMessage()
{
   _functionBlock = BTS_COMMON_ENUM_CLASS_DEFAULT_VALUE;
   _opCode = BTS_COMMON_ENUM_CLASS_DEFAULT_VALUE;
   _btsSourceFunctionBlock = BTS_FB_NONE;
   _app2BtsOpcode = App2BtsOC_None;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   // _objectPath is empty
   _token = ::ccdbusif::DEFAULT_ACT;
   // _app2BtsCompareItem
   _isResponseMessage = false;
   _timeout = 0U;
   // _objectId is empty
   _countBts2IpcMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Bts2Ipc_BaseMessage::Bts2Ipc_BaseMessage(IN const BTSCommonEnumClass functionBlock, IN const BTSCommonEnumClass opCode)
{
   _functionBlock = functionBlock;
   _opCode = opCode;
   _btsSourceFunctionBlock = BTS_FB_NONE;
   _app2BtsOpcode = App2BtsOC_None;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   // _objectPath is empty
   _token = ::ccdbusif::DEFAULT_ACT;
   // _app2BtsCompareItem
   _isResponseMessage = false;
   _timeout = 0U;
   // _objectId is empty
   _countBts2IpcMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Bts2Ipc_BaseMessage::Bts2Ipc_BaseMessage(IN const Bts2Ipc_BaseMessage& ref)
{
   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _btsSourceFunctionBlock = ref._btsSourceFunctionBlock;
   _app2BtsOpcode = ref._app2BtsOpcode;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _objectPath = ref._objectPath;
   _token = ref._token;
   _app2BtsCompareItem = ref._app2BtsCompareItem;
   _isResponseMessage = ref._isResponseMessage;
   _timeout = ref._timeout;
   _objectId = ref._objectId;
   _countBts2IpcMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Bts2Ipc_BaseMessage& Bts2Ipc_BaseMessage::operator=(IN const Bts2Ipc_BaseMessage& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _btsSourceFunctionBlock = ref._btsSourceFunctionBlock;
   _app2BtsOpcode = ref._app2BtsOpcode;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _objectPath = ref._objectPath;
   _token = ref._token;
   _app2BtsCompareItem = ref._app2BtsCompareItem;
   _isResponseMessage = ref._isResponseMessage;
   _timeout = ref._timeout;
   _objectId = ref._objectId;
   // do not increment --- _countBts2IpcMessages++;

   return *this;
}

Bts2Ipc_BaseMessage::~Bts2Ipc_BaseMessage()
{
   if(_countBts2IpcMessages) _countBts2IpcMessages--;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_DEL_OBJ(this);
#endif
}

void Bts2Ipc_BaseMessage::doOutputTrace(void)
{
   // is done by derived class
}

uint32_t Bts2Ipc_BaseMessage::getMessageTraceId(void) const
{
   return calcMessageTraceId((uint32_t)_component, (uint32_t)_stackInterface, (uint32_t)_opCode);
}

} //btstackif
