/**
 * @file Bts2App_Messaging.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_MESSAGING.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MESSAGING.
 */

#include "Bts2App_Messaging.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfMessagingCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbMessagingInitialized::Bts2App_FbMessagingInitialized()
: Bts2App_BaseMessage(BTS_FB_MESSAGING, Bts2AppOC_FbMessagingInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbMessagingInitialized::Bts2App_FbMessagingInitialized(IN const Bts2App_FbMessagingInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbMessagingInitialized& Bts2App_FbMessagingInitialized::operator=(IN const Bts2App_FbMessagingInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbMessagingInitialized::~Bts2App_FbMessagingInitialized()
{
}

void Bts2App_FbMessagingInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getMessagingCallback())
   {
      callback.getMessagingCallback()->fbMessagingInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbMessagingInitialized::clone(void) const
{
   return new Bts2App_FbMessagingInitialized(*this);
}

Bts2App_SetMessagingDummyResult::Bts2App_SetMessagingDummyResult()
: Bts2App_BaseMessage(BTS_FB_MESSAGING, Bts2AppOC_SetMessagingDummyResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetMessagingDummyResult::Bts2App_SetMessagingDummyResult(IN const Bts2App_SetMessagingDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetMessagingDummyResult& Bts2App_SetMessagingDummyResult::operator=(IN const Bts2App_SetMessagingDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetMessagingDummyResult::~Bts2App_SetMessagingDummyResult()
{
}

void Bts2App_SetMessagingDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getMessagingCallback())
   {
      callback.getMessagingCallback()->setMessagingDummyResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetMessagingDummyResult::clone(void) const
{
   return new Bts2App_SetMessagingDummyResult(*this);
}

} //btstackif
