/**
 * @file Bts2App_Ecnr.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_ECNR.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_ECNR.
 */

#include "Bts2App_Ecnr.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfEcnrCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbEcnrInitialized::Bts2App_FbEcnrInitialized()
: Bts2App_BaseMessage(BTS_FB_ECNR, Bts2AppOC_FbEcnrInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbEcnrInitialized::Bts2App_FbEcnrInitialized(IN const Bts2App_FbEcnrInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbEcnrInitialized& Bts2App_FbEcnrInitialized::operator=(IN const Bts2App_FbEcnrInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbEcnrInitialized::~Bts2App_FbEcnrInitialized()
{
}

void Bts2App_FbEcnrInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getEcnrCallback())
   {
      callback.getEcnrCallback()->fbEcnrInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbEcnrInitialized::clone(void) const
{
   return new Bts2App_FbEcnrInitialized(*this);
}

Bts2App_SetEcnrDummyResult::Bts2App_SetEcnrDummyResult()
: Bts2App_BaseMessage(BTS_FB_ECNR, Bts2AppOC_SetEcnrDummyResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetEcnrDummyResult::Bts2App_SetEcnrDummyResult(IN const Bts2App_SetEcnrDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetEcnrDummyResult& Bts2App_SetEcnrDummyResult::operator=(IN const Bts2App_SetEcnrDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetEcnrDummyResult::~Bts2App_SetEcnrDummyResult()
{
}

void Bts2App_SetEcnrDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getEcnrCallback())
   {
      callback.getEcnrCallback()->setEcnrDummyResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetEcnrDummyResult::clone(void) const
{
   return new Bts2App_SetEcnrDummyResult(*this);
}

} //btstackif
