/**
 * @file Bts2App_Config.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_CONFIG.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_CONFIG.
 */

#include "Bts2App_Config.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfConfigCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_SetDummyResult::Bts2App_SetDummyResult()
: Bts2App_BaseMessage(BTS_FB_CONFIG, Bts2AppOC_SetDummyResult)
{
   _result = BTS_REQ_LAST;
   // _remoteDeviceAddress: init is done by member constructor
}

Bts2App_SetDummyResult::Bts2App_SetDummyResult(IN const Bts2App_SetDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _remoteDeviceAddress = ref._remoteDeviceAddress;
}

Bts2App_SetDummyResult& Bts2App_SetDummyResult::operator=(IN const Bts2App_SetDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _remoteDeviceAddress = ref._remoteDeviceAddress;

   return *this;
}

Bts2App_SetDummyResult::~Bts2App_SetDummyResult()
{
}

void Bts2App_SetDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConfigCallback())
   {
      callback.getConfigCallback()->setDummyResultCB(_result, _deviceAddress, _remoteDeviceAddress);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetDummyResult::clone(void) const
{
   return new Bts2App_SetDummyResult(*this);
}

} //btstackif
