/**
 * @file Bts2App_BaseMessage.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of base message for BtStackIf to Application messages.
 */

#include "Bts2App_BaseMessage.h"
#include "BtsUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
#include "FwMemoryChecker.h"
#endif

namespace btstackif {

unsigned int Bts2App_BaseMessage::_countBts2AppMessages = 0;

Bts2App_BaseMessage::Bts2App_BaseMessage()
{
   _functionBlock = BTS_FB_NONE;
   _opCode = Bts2AppOC_None;
   _callback = NULL;
   _sessionHandle = 0;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   _countBts2AppMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Bts2App_BaseMessage::Bts2App_BaseMessage(IN const BTSFunctionBlock functionBlock, IN const BTSBts2AppOpcode opCode)
{
   _functionBlock = functionBlock;
   _opCode = opCode;
   _callback = NULL;
   _sessionHandle = 0;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   _countBts2AppMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Bts2App_BaseMessage::Bts2App_BaseMessage(IN const Bts2App_BaseMessage& ref)
{
   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _callback = NULL;
   setCallback(ref._callback);
   _sessionHandle = ref._sessionHandle;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _countBts2AppMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

Bts2App_BaseMessage& Bts2App_BaseMessage::operator=(IN const Bts2App_BaseMessage& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _callback = NULL;
   setCallback(ref._callback);
   _sessionHandle = ref._sessionHandle;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   // do not increment --- _countBts2AppMessages++;

   return *this;
}

Bts2App_BaseMessage::~Bts2App_BaseMessage()
{
   _callback = NULL;
   if(_countBts2AppMessages) _countBts2AppMessages--;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_DEL_OBJ(this);
#endif
}

void Bts2App_BaseMessage::doOutputTrace(void)
{
   // is done by derived class
}

void Bts2App_BaseMessage::triggerCallback(IN BtStackIfCallback& callback)
{
   (void)(callback);

   // is done by derived class
}

uint32_t Bts2App_BaseMessage::getMessageTraceId(void) const
{
   return calcMessageTraceId((uint32_t)_component, (uint32_t)_stackInterface, (uint32_t)_opCode);
}

} //btstackif
