/**
 * @file Bts2App_Wbl.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_WBL.
 */

#ifndef _BTS_2_APP_WBL_MSG_H_
#define _BTS_2_APP_WBL_MSG_H_

#include "Bts2App_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class Bts2App_FbWblInitialized : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_FbWblInitialized();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_FbWblInitialized(IN const Bts2App_FbWblInitialized& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_FbWblInitialized& operator=(IN const Bts2App_FbWblInitialized& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_FbWblInitialized();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_SetWblDummyResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SetWblDummyResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SetWblDummyResult(IN const Bts2App_SetWblDummyResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SetWblDummyResult& operator=(IN const Bts2App_SetWblDummyResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SetWblDummyResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_AllowWblCommunicationResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_AllowWblCommunicationResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_AllowWblCommunicationResult(IN const Bts2App_AllowWblCommunicationResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_AllowWblCommunicationResult& operator=(IN const Bts2App_AllowWblCommunicationResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_AllowWblCommunicationResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2App_BlockWblCommunicationResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_BlockWblCommunicationResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_BlockWblCommunicationResult(IN const Bts2App_BlockWblCommunicationResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_BlockWblCommunicationResult& operator=(IN const Bts2App_BlockWblCommunicationResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_BlockWblCommunicationResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2App_WblCommunicationStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_WblCommunicationStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_WblCommunicationStatus(IN const Bts2App_WblCommunicationStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_WblCommunicationStatus& operator=(IN const Bts2App_WblCommunicationStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_WblCommunicationStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setEnabled(IN const bool enabled) { _enabled = enabled; }

   inline bool getEnabled(void) const { return _enabled; }

private:
   bool _enabled; /**< parameter enabled */
};

/**
 *
 */
class Bts2App_WblServiceAvailability : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_WblServiceAvailability();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_WblServiceAvailability(IN const Bts2App_WblServiceAvailability& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_WblServiceAvailability& operator=(IN const Bts2App_WblServiceAvailability& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_WblServiceAvailability();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setServiceAvailable(IN const bool serviceAvailable) { _serviceAvailable = serviceAvailable; }

   inline bool getServiceAvailable(void) const { return _serviceAvailable; }

private:
   bool _serviceAvailable; /**< parameter service available */
};

/**
 *
 */
class Bts2App_WblLastIntendedMode : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_WblLastIntendedMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_WblLastIntendedMode(IN const Bts2App_WblLastIntendedMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_WblLastIntendedMode& operator=(IN const Bts2App_WblLastIntendedMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_WblLastIntendedMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setWblLastIntendedModeList(IN const BTSWblLastIntendedModeList& lastIntendedModeList) { _lastIntendedModeList = lastIntendedModeList; }

   inline void getWblLastIntendedModeList(OUT BTSWblLastIntendedModeList& lastIntendedModeList) const { lastIntendedModeList = _lastIntendedModeList; }
   inline const BTSWblLastIntendedModeList& getWblLastIntendedModeList(void) const { return _lastIntendedModeList; }
   inline BTSWblLastIntendedModeList& getWblLastIntendedModeListMutable(void) { return _lastIntendedModeList; }

private:
   BTSWblLastIntendedModeList _lastIntendedModeList; /**< parameter last intended mode list */
};

/**
 *
 */
class Bts2App_WblSupportedRestrictions : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_WblSupportedRestrictions();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_WblSupportedRestrictions(IN const Bts2App_WblSupportedRestrictions& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_WblSupportedRestrictions& operator=(IN const Bts2App_WblSupportedRestrictions& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_WblSupportedRestrictions();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setWblSupportedRestrictionEntryList(IN const BTSWblSupportedRestrictionEntryList& supportedRestrictionList) { _supportedRestrictionList = supportedRestrictionList; }

   inline void getWblSupportedRestrictionEntryList(OUT BTSWblSupportedRestrictionEntryList& supportedRestrictionList) const { supportedRestrictionList = _supportedRestrictionList; }
   inline const BTSWblSupportedRestrictionEntryList& getWblSupportedRestrictionEntryList(void) const { return _supportedRestrictionList; }
   inline BTSWblSupportedRestrictionEntryList& getWblSupportedRestrictionEntryListMutable(void) { return _supportedRestrictionList; }

private:
   BTSWblSupportedRestrictionEntryList _supportedRestrictionList; /**< parameter supported restriction list */
};

/**
 *
 */
class Bts2App_WblWiFiSetupStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_WblWiFiSetupStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_WblWiFiSetupStatus(IN const Bts2App_WblWiFiSetupStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_WblWiFiSetupStatus& operator=(IN const Bts2App_WblWiFiSetupStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_WblWiFiSetupStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setWblWiFiSetupStatusEntryList(IN const BTSWblWiFiSetupStatusEntryList& wifiSetupStatusList) { _wifiSetupStatusList = wifiSetupStatusList; }

   inline void getWblWiFiSetupStatusEntryList(OUT BTSWblWiFiSetupStatusEntryList& wifiSetupStatusList) const { wifiSetupStatusList = _wifiSetupStatusList; }
   inline const BTSWblWiFiSetupStatusEntryList& getWblWiFiSetupStatusEntryList(void) const { return _wifiSetupStatusList; }
   inline BTSWblWiFiSetupStatusEntryList& getWblWiFiSetupStatusEntryListMutable(void) { return _wifiSetupStatusList; }

private:
   BTSWblWiFiSetupStatusEntryList _wifiSetupStatusList; /**< parameter wifi setup status list */
};

/**
 *
 */
class Bts2App_WblHealthinessIndicator : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_WblHealthinessIndicator();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_WblHealthinessIndicator(IN const Bts2App_WblHealthinessIndicator& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_WblHealthinessIndicator& operator=(IN const Bts2App_WblHealthinessIndicator& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_WblHealthinessIndicator();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setWblHealthinessIndicator(IN const BTSWblHealthinessIndicator value) { _value = value; }

   inline BTSWblHealthinessIndicator getWblHealthinessIndicator(void) const { return _value; }

private:
   BTSWblHealthinessIndicator _value; /**< parameter value */
};

} //btstackif

#endif //_BTS_2_APP_WBL_MSG_H_
