/**
 * @file Bts2App_Telephony.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_TELEPHONY.
 */

#ifndef _BTS_2_APP_TELEPHONY_MSG_H_
#define _BTS_2_APP_TELEPHONY_MSG_H_

#include "Bts2App_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class Bts2App_FbTelephonyInitialized : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_FbTelephonyInitialized();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_FbTelephonyInitialized(IN const Bts2App_FbTelephonyInitialized& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_FbTelephonyInitialized& operator=(IN const Bts2App_FbTelephonyInitialized& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_FbTelephonyInitialized();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_SetTelephonyDummyResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SetTelephonyDummyResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SetTelephonyDummyResult(IN const Bts2App_SetTelephonyDummyResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SetTelephonyDummyResult& operator=(IN const Bts2App_SetTelephonyDummyResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SetTelephonyDummyResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

} //btstackif

#endif //_BTS_2_APP_TELEPHONY_MSG_H_
