/**
 * @file Bts2App_MessageWrapper.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Wrapper for BtStackIf to Application messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wrapper for BtStackIf to Application messages.
 * The only reason for this file is to solve following lint warnings:
 * Warning 429: prio2: Custodial pointer 'ptrMessage' ...
 */

#ifndef _BTS_2_APP_MESSAGE_WRAPPER_H_
#define _BTS_2_APP_MESSAGE_WRAPPER_H_

#include "Bts2App_Config.h"
#include "Bts2App_Connection.h"
#include "Bts2App_Telephony.h"
#include "Bts2App_Phonebook.h"
#include "Bts2App_Messaging.h"
#include "Bts2App_MediaPlayer.h"
#include "Bts2App_Wbl.h"
#include "Bts2App_Ecnr.h"

namespace btstackif {

inline Bts2App_SetDummyResult* ptrNew_Bts2App_SetDummyResult(void) { return new Bts2App_SetDummyResult(); }
inline Bts2App_FbConnectionInitialized* ptrNew_Bts2App_FbConnectionInitialized(void) { return new Bts2App_FbConnectionInitialized(); }
inline Bts2App_LocalVersionInfo* ptrNew_Bts2App_LocalVersionInfo(void) { return new Bts2App_LocalVersionInfo(); }
inline Bts2App_SwitchBluetoothOnOffResult* ptrNew_Bts2App_SwitchBluetoothOnOffResult(void) { return new Bts2App_SwitchBluetoothOnOffResult(); }
inline Bts2App_CurrentBluetoothOnOffStatus* ptrNew_Bts2App_CurrentBluetoothOnOffStatus(void) { return new Bts2App_CurrentBluetoothOnOffStatus(); }
inline Bts2App_SwitchBluetoothHardwareOnOffResult* ptrNew_Bts2App_SwitchBluetoothHardwareOnOffResult(void) { return new Bts2App_SwitchBluetoothHardwareOnOffResult(); }
inline Bts2App_SetLocalBtNameResult* ptrNew_Bts2App_SetLocalBtNameResult(void) { return new Bts2App_SetLocalBtNameResult(); }
inline Bts2App_CurrentLocalBtName* ptrNew_Bts2App_CurrentLocalBtName(void) { return new Bts2App_CurrentLocalBtName(); }
inline Bts2App_CurrentDeviceForRestrictedPairingConnecting* ptrNew_Bts2App_CurrentDeviceForRestrictedPairingConnecting(void) { return new Bts2App_CurrentDeviceForRestrictedPairingConnecting(); }
inline Bts2App_SetLocalAdapterModesResult* ptrNew_Bts2App_SetLocalAdapterModesResult(void) { return new Bts2App_SetLocalAdapterModesResult(); }
inline Bts2App_CurrentDiscoverableMode* ptrNew_Bts2App_CurrentDiscoverableMode(void) { return new Bts2App_CurrentDiscoverableMode(); }
inline Bts2App_CurrentConnectableMode* ptrNew_Bts2App_CurrentConnectableMode(void) { return new Bts2App_CurrentConnectableMode(); }
inline Bts2App_StartDiscoveryResult* ptrNew_Bts2App_StartDiscoveryResult(void) { return new Bts2App_StartDiscoveryResult(); }
inline Bts2App_StopDiscoveryResult* ptrNew_Bts2App_StopDiscoveryResult(void) { return new Bts2App_StopDiscoveryResult(); }
inline Bts2App_DiscoveringStatus* ptrNew_Bts2App_DiscoveringStatus(void) { return new Bts2App_DiscoveringStatus(); }
inline Bts2App_DiscoveredDeviceFound* ptrNew_Bts2App_DiscoveredDeviceFound(void) { return new Bts2App_DiscoveredDeviceFound(); }
inline Bts2App_StartPairingResult* ptrNew_Bts2App_StartPairingResult(void) { return new Bts2App_StartPairingResult(); }
inline Bts2App_PinCodeRequested* ptrNew_Bts2App_PinCodeRequested(void) { return new Bts2App_PinCodeRequested(); }
inline Bts2App_SecureSimplePairingRequested* ptrNew_Bts2App_SecureSimplePairingRequested(void) { return new Bts2App_SecureSimplePairingRequested(); }
inline Bts2App_PairingFinished* ptrNew_Bts2App_PairingFinished(void) { return new Bts2App_PairingFinished(); }
inline Bts2App_LinkKeyRequested* ptrNew_Bts2App_LinkKeyRequested(void) { return new Bts2App_LinkKeyRequested(); }
inline Bts2App_ConnectProtocolResult* ptrNew_Bts2App_ConnectProtocolResult(void) { return new Bts2App_ConnectProtocolResult(); }
inline Bts2App_RemoteProtocolConnectRequest* ptrNew_Bts2App_RemoteProtocolConnectRequest(void) { return new Bts2App_RemoteProtocolConnectRequest(); }
inline Bts2App_DisconnectProtocolResult* ptrNew_Bts2App_DisconnectProtocolResult(void) { return new Bts2App_DisconnectProtocolResult(); }
inline Bts2App_DisconnectDeviceResult* ptrNew_Bts2App_DisconnectDeviceResult(void) { return new Bts2App_DisconnectDeviceResult(); }
inline Bts2App_ProtocolConnectionStatus* ptrNew_Bts2App_ProtocolConnectionStatus(void) { return new Bts2App_ProtocolConnectionStatus(); }
inline Bts2App_DeviceConnectionStatus* ptrNew_Bts2App_DeviceConnectionStatus(void) { return new Bts2App_DeviceConnectionStatus(); }
inline Bts2App_DeviceCapabilities* ptrNew_Bts2App_DeviceCapabilities(void) { return new Bts2App_DeviceCapabilities(); }
inline Bts2App_RemoteSupportedServices* ptrNew_Bts2App_RemoteSupportedServices(void) { return new Bts2App_RemoteSupportedServices(); }
inline Bts2App_RemoteSppCapabilities* ptrNew_Bts2App_RemoteSppCapabilities(void) { return new Bts2App_RemoteSppCapabilities(); }
inline Bts2App_RemoteDeviceIdServiceRecords* ptrNew_Bts2App_RemoteDeviceIdServiceRecords(void) { return new Bts2App_RemoteDeviceIdServiceRecords(); }
inline Bts2App_RemoteServiceSearchResult* ptrNew_Bts2App_RemoteServiceSearchResult(void) { return new Bts2App_RemoteServiceSearchResult(); }
inline Bts2App_RemoteNameResult* ptrNew_Bts2App_RemoteNameResult(void) { return new Bts2App_RemoteNameResult(); }
inline Bts2App_RemoteNameStatus* ptrNew_Bts2App_RemoteNameStatus(void) { return new Bts2App_RemoteNameStatus(); }
inline Bts2App_LinkQualityResult* ptrNew_Bts2App_LinkQualityResult(void) { return new Bts2App_LinkQualityResult(); }
inline Bts2App_StartTestModeResult* ptrNew_Bts2App_StartTestModeResult(void) { return new Bts2App_StartTestModeResult(); }
inline Bts2App_StopTestModeResult* ptrNew_Bts2App_StopTestModeResult(void) { return new Bts2App_StopTestModeResult(); }
inline Bts2App_TestModeStatus* ptrNew_Bts2App_TestModeStatus(void) { return new Bts2App_TestModeStatus(); }
inline Bts2App_TestModeLinkQualityResult* ptrNew_Bts2App_TestModeLinkQualityResult(void) { return new Bts2App_TestModeLinkQualityResult(); }
inline Bts2App_FbTelephonyInitialized* ptrNew_Bts2App_FbTelephonyInitialized(void) { return new Bts2App_FbTelephonyInitialized(); }
inline Bts2App_SetTelephonyDummyResult* ptrNew_Bts2App_SetTelephonyDummyResult(void) { return new Bts2App_SetTelephonyDummyResult(); }
inline Bts2App_FbPhonebookInitialized* ptrNew_Bts2App_FbPhonebookInitialized(void) { return new Bts2App_FbPhonebookInitialized(); }
inline Bts2App_SetPhonebookDummyResult* ptrNew_Bts2App_SetPhonebookDummyResult(void) { return new Bts2App_SetPhonebookDummyResult(); }
inline Bts2App_FbMessagingInitialized* ptrNew_Bts2App_FbMessagingInitialized(void) { return new Bts2App_FbMessagingInitialized(); }
inline Bts2App_SetMessagingDummyResult* ptrNew_Bts2App_SetMessagingDummyResult(void) { return new Bts2App_SetMessagingDummyResult(); }
inline Bts2App_FbMediaPlayerInitialized* ptrNew_Bts2App_FbMediaPlayerInitialized(void) { return new Bts2App_FbMediaPlayerInitialized(); }
inline Bts2App_SetMediaPlayerDummyResult* ptrNew_Bts2App_SetMediaPlayerDummyResult(void) { return new Bts2App_SetMediaPlayerDummyResult(); }
inline Bts2App_FbWblInitialized* ptrNew_Bts2App_FbWblInitialized(void) { return new Bts2App_FbWblInitialized(); }
inline Bts2App_SetWblDummyResult* ptrNew_Bts2App_SetWblDummyResult(void) { return new Bts2App_SetWblDummyResult(); }
inline Bts2App_AllowWblCommunicationResult* ptrNew_Bts2App_AllowWblCommunicationResult(void) { return new Bts2App_AllowWblCommunicationResult(); }
inline Bts2App_BlockWblCommunicationResult* ptrNew_Bts2App_BlockWblCommunicationResult(void) { return new Bts2App_BlockWblCommunicationResult(); }
inline Bts2App_WblCommunicationStatus* ptrNew_Bts2App_WblCommunicationStatus(void) { return new Bts2App_WblCommunicationStatus(); }
inline Bts2App_WblServiceAvailability* ptrNew_Bts2App_WblServiceAvailability(void) { return new Bts2App_WblServiceAvailability(); }
inline Bts2App_WblLastIntendedMode* ptrNew_Bts2App_WblLastIntendedMode(void) { return new Bts2App_WblLastIntendedMode(); }
inline Bts2App_WblSupportedRestrictions* ptrNew_Bts2App_WblSupportedRestrictions(void) { return new Bts2App_WblSupportedRestrictions(); }
inline Bts2App_WblWiFiSetupStatus* ptrNew_Bts2App_WblWiFiSetupStatus(void) { return new Bts2App_WblWiFiSetupStatus(); }
inline Bts2App_WblHealthinessIndicator* ptrNew_Bts2App_WblHealthinessIndicator(void) { return new Bts2App_WblHealthinessIndicator(); }
inline Bts2App_FbEcnrInitialized* ptrNew_Bts2App_FbEcnrInitialized(void) { return new Bts2App_FbEcnrInitialized(); }
inline Bts2App_SetEcnrDummyResult* ptrNew_Bts2App_SetEcnrDummyResult(void) { return new Bts2App_SetEcnrDummyResult(); }

} //btstackif

#endif //_BTS_2_APP_MESSAGE_WRAPPER_H_
