/**
 * @file Bts2App_Connection.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_CONNECTION.
 */

#ifndef _BTS_2_APP_CONNECTION_MSG_H_
#define _BTS_2_APP_CONNECTION_MSG_H_

#include "Bts2App_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class Bts2App_FbConnectionInitialized : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_FbConnectionInitialized();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_FbConnectionInitialized(IN const Bts2App_FbConnectionInitialized& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_FbConnectionInitialized& operator=(IN const Bts2App_FbConnectionInitialized& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_FbConnectionInitialized();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_LocalVersionInfo : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_LocalVersionInfo();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_LocalVersionInfo(IN const Bts2App_LocalVersionInfo& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_LocalVersionInfo& operator=(IN const Bts2App_LocalVersionInfo& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_LocalVersionInfo();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setLocalVersionInfo(IN const BTSLocalVersionInfo& versionInfo) { _versionInfo = versionInfo; }

   inline void getLocalVersionInfo(OUT BTSLocalVersionInfo& versionInfo) const { versionInfo = _versionInfo; }
   inline const BTSLocalVersionInfo& getLocalVersionInfo(void) const { return _versionInfo; }
   inline BTSLocalVersionInfo& getLocalVersionInfoMutable(void) { return _versionInfo; }

private:
   BTSLocalVersionInfo _versionInfo; /**< parameter version info */
};

/**
 *
 */
class Bts2App_SwitchBluetoothOnOffResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SwitchBluetoothOnOffResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SwitchBluetoothOnOffResult(IN const Bts2App_SwitchBluetoothOnOffResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SwitchBluetoothOnOffResult& operator=(IN const Bts2App_SwitchBluetoothOnOffResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SwitchBluetoothOnOffResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_CurrentBluetoothOnOffStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_CurrentBluetoothOnOffStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_CurrentBluetoothOnOffStatus(IN const Bts2App_CurrentBluetoothOnOffStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_CurrentBluetoothOnOffStatus& operator=(IN const Bts2App_CurrentBluetoothOnOffStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_CurrentBluetoothOnOffStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setBluetoothMode(IN const BTSBluetoothMode bluetoothMode) { _bluetoothMode = bluetoothMode; }
   inline void setBluetoothOffReason(IN const BTSBluetoothOffReason offReason) { _offReason = offReason; }
   inline void setAdapterMode(IN const BTSAdapterMode adapterMode) { _adapterMode = adapterMode; }

   inline BTSBluetoothMode getBluetoothMode(void) const { return _bluetoothMode; }
   inline BTSBluetoothOffReason getBluetoothOffReason(void) const { return _offReason; }
   inline BTSAdapterMode getAdapterMode(void) const { return _adapterMode; }

private:
   BTSBluetoothMode _bluetoothMode; /**< parameter bluetooth mode */
   BTSBluetoothOffReason _offReason; /**< parameter off reason */
   BTSAdapterMode _adapterMode; /**< parameter adapter mode */
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2App_SwitchBluetoothHardwareOnOffResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SwitchBluetoothHardwareOnOffResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SwitchBluetoothHardwareOnOffResult(IN const Bts2App_SwitchBluetoothHardwareOnOffResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SwitchBluetoothHardwareOnOffResult& operator=(IN const Bts2App_SwitchBluetoothHardwareOnOffResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SwitchBluetoothHardwareOnOffResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_SetLocalBtNameResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SetLocalBtNameResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SetLocalBtNameResult(IN const Bts2App_SetLocalBtNameResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SetLocalBtNameResult& operator=(IN const Bts2App_SetLocalBtNameResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SetLocalBtNameResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
};

/**
 *
 */
class Bts2App_CurrentLocalBtName : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_CurrentLocalBtName();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_CurrentLocalBtName(IN const Bts2App_CurrentLocalBtName& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_CurrentLocalBtName& operator=(IN const Bts2App_CurrentLocalBtName& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_CurrentLocalBtName();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& adapterName) { _adapterName = adapterName; }

   inline void getDeviceName(OUT BTSDeviceName& adapterName) const { adapterName = _adapterName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _adapterName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _adapterName; }

private:
   BTSDeviceName _adapterName; /**< parameter adapter name */
};

/**
 *
 */
class Bts2App_CurrentDeviceForRestrictedPairingConnecting : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_CurrentDeviceForRestrictedPairingConnecting();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_CurrentDeviceForRestrictedPairingConnecting(IN const Bts2App_CurrentDeviceForRestrictedPairingConnecting& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_CurrentDeviceForRestrictedPairingConnecting& operator=(IN const Bts2App_CurrentDeviceForRestrictedPairingConnecting& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_CurrentDeviceForRestrictedPairingConnecting();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_SetLocalAdapterModesResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SetLocalAdapterModesResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SetLocalAdapterModesResult(IN const Bts2App_SetLocalAdapterModesResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SetLocalAdapterModesResult& operator=(IN const Bts2App_SetLocalAdapterModesResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SetLocalAdapterModesResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_CurrentDiscoverableMode : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_CurrentDiscoverableMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_CurrentDiscoverableMode(IN const Bts2App_CurrentDiscoverableMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_CurrentDiscoverableMode& operator=(IN const Bts2App_CurrentDiscoverableMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_CurrentDiscoverableMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDiscoverableMode(IN const BTSLocalMode discoverableMode) { _discoverableMode = discoverableMode; }
   inline void setLocalModeOffReason(IN const BTSLocalModeOffReason offReason) { _offReason = offReason; }

   inline BTSLocalMode getDiscoverableMode(void) const { return _discoverableMode; }
   inline BTSLocalModeOffReason getLocalModeOffReason(void) const { return _offReason; }

private:
   BTSLocalMode _discoverableMode; /**< parameter discoverable mode */
   BTSLocalModeOffReason _offReason; /**< parameter off reason */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_CurrentConnectableMode : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_CurrentConnectableMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_CurrentConnectableMode(IN const Bts2App_CurrentConnectableMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_CurrentConnectableMode& operator=(IN const Bts2App_CurrentConnectableMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_CurrentConnectableMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setConnectableMode(IN const BTSLocalMode connectableMode) { _connectableMode = connectableMode; }
   inline void setLocalModeOffReason(IN const BTSLocalModeOffReason offReason) { _offReason = offReason; }

   inline BTSLocalMode getConnectableMode(void) const { return _connectableMode; }
   inline BTSLocalModeOffReason getLocalModeOffReason(void) const { return _offReason; }

private:
   BTSLocalMode _connectableMode; /**< parameter connectable mode */
   BTSLocalModeOffReason _offReason; /**< parameter off reason */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_StartDiscoveryResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_StartDiscoveryResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_StartDiscoveryResult(IN const Bts2App_StartDiscoveryResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_StartDiscoveryResult& operator=(IN const Bts2App_StartDiscoveryResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_StartDiscoveryResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_StopDiscoveryResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_StopDiscoveryResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_StopDiscoveryResult(IN const Bts2App_StopDiscoveryResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_StopDiscoveryResult& operator=(IN const Bts2App_StopDiscoveryResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_StopDiscoveryResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_DiscoveringStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_DiscoveringStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_DiscoveringStatus(IN const Bts2App_DiscoveringStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_DiscoveringStatus& operator=(IN const Bts2App_DiscoveringStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_DiscoveringStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDiscoveringStatus(IN const BTSDiscoveringStatus discoveringStatus) { _discoveringStatus = discoveringStatus; }

   inline BTSDiscoveringStatus getDiscoveringStatus(void) const { return _discoveringStatus; }

private:
   BTSDiscoveringStatus _discoveringStatus; /**< parameter discovering status */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_DiscoveredDeviceFound : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_DiscoveredDeviceFound();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_DiscoveredDeviceFound(IN const Bts2App_DiscoveredDeviceFound& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_DiscoveredDeviceFound& operator=(IN const Bts2App_DiscoveredDeviceFound& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_DiscoveredDeviceFound();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDiscoveredDeviceInfo(IN const BTSDiscoveredDeviceInfo& discoveredDevice) { _discoveredDevice = discoveredDevice; }

   inline void getDiscoveredDeviceInfo(OUT BTSDiscoveredDeviceInfo& discoveredDevice) const { discoveredDevice = _discoveredDevice; }
   inline const BTSDiscoveredDeviceInfo& getDiscoveredDeviceInfo(void) const { return _discoveredDevice; }
   inline BTSDiscoveredDeviceInfo& getDiscoveredDeviceInfoMutable(void) { return _discoveredDevice; }

private:
   BTSDiscoveredDeviceInfo _discoveredDevice; /**< parameter discovered device */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_StartPairingResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_StartPairingResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_StartPairingResult(IN const Bts2App_StartPairingResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_StartPairingResult& operator=(IN const Bts2App_StartPairingResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_StartPairingResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_PinCodeRequested : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_PinCodeRequested();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_PinCodeRequested(IN const Bts2App_PinCodeRequested& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_PinCodeRequested& operator=(IN const Bts2App_PinCodeRequested& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_PinCodeRequested();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }
   inline void setPairConnectOriginator(IN const BTSPairConnectOriginator pairingOriginator) { _pairingOriginator = pairingOriginator; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }
   inline BTSPairConnectOriginator getPairConnectOriginator(void) const { return _pairingOriginator; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSDeviceName _deviceName; /**< parameter device name */
   BTSPairConnectOriginator _pairingOriginator; /**< parameter pairing originator */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_SecureSimplePairingRequested : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SecureSimplePairingRequested();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SecureSimplePairingRequested(IN const Bts2App_SecureSimplePairingRequested& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SecureSimplePairingRequested& operator=(IN const Bts2App_SecureSimplePairingRequested& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SecureSimplePairingRequested();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }
   inline void setSspMode(IN const BTSSspMode sspMode) { _sspMode = sspMode; }
   inline void setNumericValue(IN const BTSNumericValue& numericValue) { _numericValue = numericValue; }
   inline void setPairConnectOriginator(IN const BTSPairConnectOriginator pairingOriginator) { _pairingOriginator = pairingOriginator; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }
   inline BTSSspMode getSspMode(void) const { return _sspMode; }
   inline void getNumericValue(OUT BTSNumericValue& numericValue) const { numericValue = _numericValue; }
   inline const BTSNumericValue& getNumericValue(void) const { return _numericValue; }
   inline BTSNumericValue& getNumericValueMutable(void) { return _numericValue; }
   inline BTSPairConnectOriginator getPairConnectOriginator(void) const { return _pairingOriginator; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSDeviceName _deviceName; /**< parameter device name */
   BTSSspMode _sspMode; /**< parameter ssp mode */
   BTSNumericValue _numericValue; /**< parameter numeric value */
   BTSPairConnectOriginator _pairingOriginator; /**< parameter pairing originator */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_PairingFinished : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_PairingFinished();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_PairingFinished(IN const Bts2App_PairingFinished& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_PairingFinished& operator=(IN const Bts2App_PairingFinished& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_PairingFinished();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setLinkKeyType(IN const BTSLinkKeyType linkKeyType) { _linkKeyType = linkKeyType; }
   inline void setLinkKey(IN const BTSLinkKey& linkKey) { _linkKey = linkKey; }
   inline void setDLinkKey(IN const BTSDLinkKey& dLinkKey) { _dLinkKey = dLinkKey; }
   inline void setMajorServiceClass(IN const BTSMajorServiceClass& majorServiceClass) { _majorServiceClass = majorServiceClass; }
   inline void setMajorDeviceClass(IN const BTSMajorDeviceClass majorDeviceClass) { _majorDeviceClass = majorDeviceClass; }
   inline void setMinorDeviceClass(IN const BTSMinorDeviceClass minorDeviceClass) { _minorDeviceClass = minorDeviceClass; }
   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline BTSLinkKeyType getLinkKeyType(void) const { return _linkKeyType; }
   inline void getLinkKey(OUT BTSLinkKey& linkKey) const { linkKey = _linkKey; }
   inline const BTSLinkKey& getLinkKey(void) const { return _linkKey; }
   inline BTSLinkKey& getLinkKeyMutable(void) { return _linkKey; }
   inline void getDLinkKey(OUT BTSDLinkKey& dLinkKey) const { dLinkKey = _dLinkKey; }
   inline const BTSDLinkKey& getDLinkKey(void) const { return _dLinkKey; }
   inline BTSDLinkKey& getDLinkKeyMutable(void) { return _dLinkKey; }
   inline void getMajorServiceClass(OUT BTSMajorServiceClass& majorServiceClass) const { majorServiceClass = _majorServiceClass; }
   inline const BTSMajorServiceClass& getMajorServiceClass(void) const { return _majorServiceClass; }
   inline BTSMajorServiceClass& getMajorServiceClassMutable(void) { return _majorServiceClass; }
   inline BTSMajorDeviceClass getMajorDeviceClass(void) const { return _majorDeviceClass; }
   inline BTSMinorDeviceClass getMinorDeviceClass(void) const { return _minorDeviceClass; }
   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSLinkKeyType _linkKeyType; /**< parameter link key type */
   BTSLinkKey _linkKey; /**< parameter link key */
   BTSDLinkKey _dLinkKey; /**< parameter d link key */
   BTSMajorServiceClass _majorServiceClass; /**< parameter major service class */
   BTSMajorDeviceClass _majorDeviceClass; /**< parameter major device class */
   BTSMinorDeviceClass _minorDeviceClass; /**< parameter minor device class */
   BTSDeviceName _deviceName; /**< parameter device name */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_LinkKeyRequested : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_LinkKeyRequested();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_LinkKeyRequested(IN const Bts2App_LinkKeyRequested& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_LinkKeyRequested& operator=(IN const Bts2App_LinkKeyRequested& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_LinkKeyRequested();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_ConnectProtocolResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_ConnectProtocolResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_ConnectProtocolResult(IN const Bts2App_ConnectProtocolResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_ConnectProtocolResult& operator=(IN const Bts2App_ConnectProtocolResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_ConnectProtocolResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }
   inline void setMasInstanceName(IN const BTSMasInstanceName& masInstance) { _masInstance = masInstance; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }
   inline void getMasInstanceName(OUT BTSMasInstanceName& masInstance) const { masInstance = _masInstance; }
   inline const BTSMasInstanceName& getMasInstanceName(void) const { return _masInstance; }
   inline BTSMasInstanceName& getMasInstanceNameMutable(void) { return _masInstance; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   BTSMasInstanceName _masInstance; /**< parameter mas instance */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteProtocolConnectRequest : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteProtocolConnectRequest();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteProtocolConnectRequest(IN const Bts2App_RemoteProtocolConnectRequest& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteProtocolConnectRequest& operator=(IN const Bts2App_RemoteProtocolConnectRequest& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteProtocolConnectRequest();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_DisconnectProtocolResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_DisconnectProtocolResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_DisconnectProtocolResult(IN const Bts2App_DisconnectProtocolResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_DisconnectProtocolResult& operator=(IN const Bts2App_DisconnectProtocolResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_DisconnectProtocolResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }
   inline void setMasInstanceName(IN const BTSMasInstanceName& masInstance) { _masInstance = masInstance; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }
   inline void getMasInstanceName(OUT BTSMasInstanceName& masInstance) const { masInstance = _masInstance; }
   inline const BTSMasInstanceName& getMasInstanceName(void) const { return _masInstance; }
   inline BTSMasInstanceName& getMasInstanceNameMutable(void) { return _masInstance; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   BTSMasInstanceName _masInstance; /**< parameter mas instance */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_DisconnectDeviceResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_DisconnectDeviceResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_DisconnectDeviceResult(IN const Bts2App_DisconnectDeviceResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_DisconnectDeviceResult& operator=(IN const Bts2App_DisconnectDeviceResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_DisconnectDeviceResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_ProtocolConnectionStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_ProtocolConnectionStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_ProtocolConnectionStatus(IN const Bts2App_ProtocolConnectionStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_ProtocolConnectionStatus& operator=(IN const Bts2App_ProtocolConnectionStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_ProtocolConnectionStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setConnectionStatus(IN const BTSConnectionStatus connectionStatus) { _connectionStatus = connectionStatus; }
   inline void setDisconnectReason(IN const BTSDisconnectReason disconnectReason) { _disconnectReason = disconnectReason; }
   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }
   inline void setMasInstanceName(IN const BTSMasInstanceName& masInstance) { _masInstance = masInstance; }
   inline void setDeviceName(IN const BTSDeviceName& rfCommDevice) { _rfCommDevice = rfCommDevice; }

   inline BTSConnectionStatus getConnectionStatus(void) const { return _connectionStatus; }
   inline BTSDisconnectReason getDisconnectReason(void) const { return _disconnectReason; }
   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }
   inline void getMasInstanceName(OUT BTSMasInstanceName& masInstance) const { masInstance = _masInstance; }
   inline const BTSMasInstanceName& getMasInstanceName(void) const { return _masInstance; }
   inline BTSMasInstanceName& getMasInstanceNameMutable(void) { return _masInstance; }
   inline void getDeviceName(OUT BTSDeviceName& rfCommDevice) const { rfCommDevice = _rfCommDevice; }
   inline const BTSDeviceName& getDeviceName(void) const { return _rfCommDevice; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _rfCommDevice; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSConnectionStatus _connectionStatus; /**< parameter connection status */
   BTSDisconnectReason _disconnectReason; /**< parameter disconnect reason */
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   BTSMasInstanceName _masInstance; /**< parameter mas instance */
   BTSDeviceName _rfCommDevice; /**< parameter rf comm device */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_DeviceConnectionStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_DeviceConnectionStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_DeviceConnectionStatus(IN const Bts2App_DeviceConnectionStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_DeviceConnectionStatus& operator=(IN const Bts2App_DeviceConnectionStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_DeviceConnectionStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setConnectionStatus(IN const BTSConnectionStatus connectionStatus) { _connectionStatus = connectionStatus; }
   inline void setDisconnectReason(IN const BTSDisconnectReason disconnectReason) { _disconnectReason = disconnectReason; }

   inline BTSConnectionStatus getConnectionStatus(void) const { return _connectionStatus; }
   inline BTSDisconnectReason getDisconnectReason(void) const { return _disconnectReason; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSConnectionStatus _connectionStatus; /**< parameter connection status */
   BTSDisconnectReason _disconnectReason; /**< parameter disconnect reason */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_DeviceCapabilities : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_DeviceCapabilities();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_DeviceCapabilities(IN const Bts2App_DeviceCapabilities& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_DeviceCapabilities& operator=(IN const Bts2App_DeviceCapabilities& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_DeviceCapabilities();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDeviceCapabilities(IN const BTSDeviceCapabilities& deviceCapabilities) { _deviceCapabilities = deviceCapabilities; }

   inline void getDeviceCapabilities(OUT BTSDeviceCapabilities& deviceCapabilities) const { deviceCapabilities = _deviceCapabilities; }
   inline const BTSDeviceCapabilities& getDeviceCapabilities(void) const { return _deviceCapabilities; }
   inline BTSDeviceCapabilities& getDeviceCapabilitiesMutable(void) { return _deviceCapabilities; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSDeviceCapabilities _deviceCapabilities; /**< parameter device capabilities */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteSupportedServices : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteSupportedServices();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteSupportedServices(IN const Bts2App_RemoteSupportedServices& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteSupportedServices& operator=(IN const Bts2App_RemoteSupportedServices& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteSupportedServices();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setSupportedServices(IN const BTSSupportedServices& supportedServices) { _supportedServices = supportedServices; }
   inline void setServiceInfoList(IN const BTSServiceInfoList& serviceInfoList) { _serviceInfoList = serviceInfoList; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline void getSupportedServices(OUT BTSSupportedServices& supportedServices) const { supportedServices = _supportedServices; }
   inline const BTSSupportedServices& getSupportedServices(void) const { return _supportedServices; }
   inline BTSSupportedServices& getSupportedServicesMutable(void) { return _supportedServices; }
   inline void getServiceInfoList(OUT BTSServiceInfoList& serviceInfoList) const { serviceInfoList = _serviceInfoList; }
   inline const BTSServiceInfoList& getServiceInfoList(void) const { return _serviceInfoList; }
   inline BTSServiceInfoList& getServiceInfoListMutable(void) { return _serviceInfoList; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSSupportedServices _supportedServices; /**< parameter supported services */
   BTSServiceInfoList _serviceInfoList; /**< parameter service info list */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteSppCapabilities : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteSppCapabilities();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteSppCapabilities(IN const Bts2App_RemoteSppCapabilities& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteSppCapabilities& operator=(IN const Bts2App_RemoteSppCapabilities& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteSppCapabilities();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setSppCapabilityList(IN const BTSSppCapabilityList& sspCapabilities) { _sspCapabilities = sspCapabilities; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline void getSppCapabilityList(OUT BTSSppCapabilityList& sspCapabilities) const { sspCapabilities = _sspCapabilities; }
   inline const BTSSppCapabilityList& getSppCapabilityList(void) const { return _sspCapabilities; }
   inline BTSSppCapabilityList& getSppCapabilityListMutable(void) { return _sspCapabilities; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSSppCapabilityList _sspCapabilities; /**< parameter ssp capabilities */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteDeviceIdServiceRecords : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteDeviceIdServiceRecords();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteDeviceIdServiceRecords(IN const Bts2App_RemoteDeviceIdServiceRecords& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteDeviceIdServiceRecords& operator=(IN const Bts2App_RemoteDeviceIdServiceRecords& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteDeviceIdServiceRecords();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setDeviceIdServiceRecordList(IN const BTSDeviceIdServiceRecordList& deviceIdServiceRecords) { _deviceIdServiceRecords = deviceIdServiceRecords; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline void getDeviceIdServiceRecordList(OUT BTSDeviceIdServiceRecordList& deviceIdServiceRecords) const { deviceIdServiceRecords = _deviceIdServiceRecords; }
   inline const BTSDeviceIdServiceRecordList& getDeviceIdServiceRecordList(void) const { return _deviceIdServiceRecords; }
   inline BTSDeviceIdServiceRecordList& getDeviceIdServiceRecordListMutable(void) { return _deviceIdServiceRecords; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSDeviceIdServiceRecordList _deviceIdServiceRecords; /**< parameter device id service records */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteServiceSearchResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteServiceSearchResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteServiceSearchResult(IN const Bts2App_RemoteServiceSearchResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteServiceSearchResult& operator=(IN const Bts2App_RemoteServiceSearchResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteServiceSearchResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setSupportedServicesResult(IN const BTSRequestResult supportedServicesResult) { _supportedServicesResult = supportedServicesResult; }
   inline void setSppCapabilitiesResult(IN const BTSRequestResult sppCapabilitiesResult) { _sppCapabilitiesResult = sppCapabilitiesResult; }
   inline void setDeviceIdServiceRecordsResult(IN const BTSRequestResult deviceIdServiceRecordsResult) { _deviceIdServiceRecordsResult = deviceIdServiceRecordsResult; }

   inline BTSRequestResult getSupportedServicesResult(void) const { return _supportedServicesResult; }
   inline BTSRequestResult getSppCapabilitiesResult(void) const { return _sppCapabilitiesResult; }
   inline BTSRequestResult getDeviceIdServiceRecordsResult(void) const { return _deviceIdServiceRecordsResult; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _supportedServicesResult; /**< parameter supported services result */
   BTSRequestResult _sppCapabilitiesResult; /**< parameter spp capabilities result */
   BTSRequestResult _deviceIdServiceRecordsResult; /**< parameter device id service records result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteNameResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteNameResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteNameResult(IN const Bts2App_RemoteNameResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteNameResult& operator=(IN const Bts2App_RemoteNameResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteNameResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSDeviceName _deviceName; /**< parameter device name */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_RemoteNameStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_RemoteNameStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_RemoteNameStatus(IN const Bts2App_RemoteNameStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_RemoteNameStatus& operator=(IN const Bts2App_RemoteNameStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_RemoteNameStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSDeviceName _deviceName; /**< parameter device name */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_LinkQualityResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_LinkQualityResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_LinkQualityResult(IN const Bts2App_LinkQualityResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_LinkQualityResult& operator=(IN const Bts2App_LinkQualityResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_LinkQualityResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setRssi(IN const BTSRssi rssi) { _rssi = rssi; }
   inline void setLinkQuality(IN const BTSLinkQuality linkQuality) { _linkQuality = linkQuality; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline BTSRssi getRssi(void) const { return _rssi; }
   inline BTSLinkQuality getLinkQuality(void) const { return _linkQuality; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSRequestResult _result; /**< parameter result */
   BTSRssi _rssi; /**< parameter rssi */
   BTSLinkQuality _linkQuality; /**< parameter link quality */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_StartTestModeResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_StartTestModeResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_StartTestModeResult(IN const Bts2App_StartTestModeResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_StartTestModeResult& operator=(IN const Bts2App_StartTestModeResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_StartTestModeResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_StopTestModeResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_StopTestModeResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_StopTestModeResult(IN const Bts2App_StopTestModeResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_StopTestModeResult& operator=(IN const Bts2App_StopTestModeResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_StopTestModeResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }

private:
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_TestModeStatus : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_TestModeStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_TestModeStatus(IN const Bts2App_TestModeStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_TestModeStatus& operator=(IN const Bts2App_TestModeStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_TestModeStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setConnectionStatus(IN const BTSConnectionStatus connectionStatus) { _connectionStatus = connectionStatus; }

   inline BTSConnectionStatus getConnectionStatus(void) const { return _connectionStatus; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSConnectionStatus _connectionStatus; /**< parameter connection status */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class Bts2App_TestModeLinkQualityResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_TestModeLinkQualityResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_TestModeLinkQualityResult(IN const Bts2App_TestModeLinkQualityResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_TestModeLinkQualityResult& operator=(IN const Bts2App_TestModeLinkQualityResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_TestModeLinkQualityResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setRssi(IN const BTSRssi rssi) { _rssi = rssi; }
   inline void setLinkQuality(IN const BTSLinkQuality linkQuality) { _linkQuality = linkQuality; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline BTSRssi getRssi(void) const { return _rssi; }
   inline BTSLinkQuality getLinkQuality(void) const { return _linkQuality; }

private:
   BTSRequestResult _result; /**< parameter result */
   BTSRssi _rssi; /**< parameter rssi */
   BTSLinkQuality _linkQuality; /**< parameter link quality */
   // see base class: BTSSessionHandle _sessionHandle;
};

} //btstackif

#endif //_BTS_2_APP_CONNECTION_MSG_H_
